/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.FlakeyTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={FlakeyTests.class, LargeTests.class})
public class TestMasterFailover {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterFailover.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterFailover.class);
    @Rule
    public TestName name = new TestName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleMasterFailover() throws Exception {
        int NUM_MASTERS = 3;
        int NUM_RS = 3;
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        try {
            StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(3).numRegionServers(3).numDataNodes(3).build();
            TEST_UTIL.startMiniCluster(option);
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
            for (JVMClusterUtil.MasterThread mt : masterThreads) {
                Assert.assertTrue((boolean)mt.isAlive());
            }
            int numActive = 0;
            int activeIndex = -1;
            ServerName activeName = null;
            HMaster active = null;
            for (int i = 0; i < masterThreads.size(); ++i) {
                if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
                ++numActive;
                activeIndex = i;
                active = masterThreads.get(activeIndex).getMaster();
                activeName = active.getServerName();
            }
            Assert.assertEquals((long)1L, (long)numActive);
            Assert.assertEquals((long)3L, (long)masterThreads.size());
            LOG.info("Active master " + activeName);
            Assert.assertNotNull((Object)active);
            ClusterMetrics status = active.getClusterMetrics();
            Assert.assertTrue((boolean)status.getMasterName().equals((Object)activeName));
            Assert.assertEquals((long)2L, (long)status.getBackupMasterNames().size());
            int backupIndex = activeIndex == 0 ? 1 : activeIndex - 1;
            HMaster master = cluster.getMaster(backupIndex);
            LOG.debug("\n\nStopping a backup master: " + master.getServerName() + "\n");
            cluster.stopMaster(backupIndex, false);
            cluster.waitOnMaster(backupIndex);
            for (int i = 0; i < masterThreads.size(); ++i) {
                if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
                Assert.assertTrue((boolean)activeName.equals((Object)masterThreads.get(i).getMaster().getServerName()));
                activeIndex = i;
                active = masterThreads.get(activeIndex).getMaster();
            }
            Assert.assertEquals((long)1L, (long)numActive);
            Assert.assertEquals((long)2L, (long)masterThreads.size());
            int rsCount = masterThreads.get(activeIndex).getMaster().getClusterMetrics().getLiveServerMetrics().size();
            LOG.info("Active master " + active.getServerName() + " managing " + rsCount + " regions servers");
            Assert.assertEquals((long)3L, (long)rsCount);
            Assert.assertNotNull((Object)active);
            status = active.getClusterMetrics();
            Assert.assertTrue((boolean)status.getMasterName().equals((Object)activeName));
            Assert.assertEquals((long)1L, (long)status.getBackupMasterNames().size());
            LOG.debug("\n\nStopping the active master " + active.getServerName() + "\n");
            cluster.stopMaster(activeIndex, false);
            cluster.waitOnMaster(activeIndex);
            Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
            LOG.debug("\n\nVerifying backup master is now active\n");
            Assert.assertEquals((long)1L, (long)masterThreads.size());
            active = masterThreads.get(0).getMaster();
            Assert.assertNotNull((Object)active);
            status = active.getClusterMetrics();
            ServerName mastername = status.getMasterName();
            Assert.assertTrue((boolean)mastername.equals((Object)active.getServerName()));
            Assert.assertTrue((boolean)active.isActiveMaster());
            Assert.assertEquals((long)0L, (long)status.getBackupMasterNames().size());
            int rss = status.getLiveServerMetrics().size();
            LOG.info("Active master " + mastername.getServerName() + " managing " + rss + " region servers");
            Assert.assertEquals((long)3L, (long)rss);
        }
        finally {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaInTransitionWhenMasterFailover() throws Exception {
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.startMiniCluster();
        try {
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            LOG.info("Cluster started");
            HMaster activeMaster = cluster.getMaster();
            ServerName metaServerName = cluster.getServerHoldingMeta();
            HRegionServer hrs = cluster.getRegionServer(metaServerName);
            LOG.info("Aborting master");
            activeMaster.abort("test-kill");
            cluster.waitForMasterToStop(activeMaster.getServerName(), 30000L);
            LOG.info("Master has aborted");
            RegionState metaState = MetaTableLocator.getMetaRegionState((ZKWatcher)hrs.getZooKeeper());
            Assert.assertEquals((String)"hbase:meta should be online on RS", (Object)metaState.getServerName(), (Object)metaServerName);
            Assert.assertEquals((String)"hbase:meta should be online on RS", (Object)RegionState.State.OPEN, (Object)metaState.getState());
            LOG.info("Starting up a new master");
            activeMaster = cluster.startMaster().getMaster();
            LOG.info("Waiting for master to be ready");
            cluster.waitForActiveAndReadyMaster();
            LOG.info("Master is ready");
            metaState = MetaTableLocator.getMetaRegionState((ZKWatcher)activeMaster.getZooKeeper());
            Assert.assertEquals((String)"hbase:meta should be online on RS", (Object)metaState.getServerName(), (Object)metaServerName);
            Assert.assertEquals((String)"hbase:meta should be online on RS", (Object)RegionState.State.OPEN, (Object)metaState.getState());
        }
        finally {
            TEST_UTIL.shutdownMiniCluster();
        }
    }
}

