/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.JMXListener;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.MethodSorters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@Ignore
public class TestStochasticBalancerJmxMetrics
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStochasticBalancerJmxMetrics.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestStochasticBalancerJmxMetrics.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static int connectorPort = 61120;
    private static StochasticLoadBalancer loadBalancer;
    private static int[] mockCluster_ensemble;
    private static int[] mockCluster_pertable_1;
    private static int[] mockCluster_pertable_2;
    private static int[] mockCluster_pertable_namespace;
    private static final String TABLE_NAME_1 = "Table1";
    private static final String TABLE_NAME_2 = "Table2";
    private static final String TABLE_NAME_NAMESPACE = "hbase:namespace";
    private static Configuration conf;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = UTIL.getConfiguration();
        conf.setClass("hbase.util.ip.to.rack.determiner", BalancerTestBase.MockMapping.class, DNSToSwitchMapping.class);
        conf.setFloat("hbase.master.balancer.stochastic.maxMovePercent", 0.75f);
        conf.setFloat("hbase.regions.slop", 0.0f);
        conf.set("hbase.coprocessor.regionserver.classes", JMXListener.class.getName());
        Random rand = new Random();
        for (int i = 0; i < 10; ++i) {
            int sign;
            while (!HBaseTestingUtility.available(connectorPort += (sign = i % 2 == 0 ? 1 : -1) * rand.nextInt(100))) {
            }
            try {
                conf.setInt("regionserver.rmi.registry.port", connectorPort);
                UTIL.startMiniCluster();
                break;
            }
            catch (Exception e) {
                LOG.debug("Encountered exception when starting cluster. Trying port " + connectorPort, (Throwable)e);
                try {
                    UTIL.shutdownMiniCluster();
                }
                catch (Exception ex) {
                    LOG.debug("Encountered exception shutting down cluster", (Throwable)ex);
                }
                continue;
            }
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testJmxMetrics_EnsembleMode() throws Exception {
        loadBalancer = new StochasticLoadBalancer();
        conf.setBoolean("hbase.master.loadbalance.bytable", false);
        loadBalancer.setConf(conf);
        TableName tableName = HConstants.ENSEMBLE_TABLE_NAME;
        TreeMap<ServerName, List<RegionInfo>> clusterState = this.mockClusterServers(mockCluster_ensemble);
        loadBalancer.balanceCluster(tableName, clusterState);
        String[] tableNames = new String[]{tableName.getNameAsString()};
        String[] functionNames = loadBalancer.getCostFunctionNames();
        Set<String> jmxMetrics = this.readJmxMetricsWithRetry();
        Set<String> expectedMetrics = this.getExpectedJmxMetrics(tableNames, functionNames);
        for (String expected : expectedMetrics) {
            Assert.assertTrue((String)("Metric " + expected + " can not be found in JMX in ensemble mode."), (boolean)jmxMetrics.contains(expected));
        }
    }

    @Test
    public void testJmxMetrics_PerTableMode() throws Exception {
        loadBalancer = new StochasticLoadBalancer();
        conf.setBoolean("hbase.master.loadbalance.bytable", true);
        loadBalancer.setConf(conf);
        String[] functionNames = loadBalancer.getCostFunctionNames();
        loadBalancer.updateMetricsSize(3 * (functionNames.length + 1));
        TableName tableName = TableName.valueOf((String)TABLE_NAME_1);
        TreeMap<ServerName, List<RegionInfo>> clusterState = this.mockClusterServers(mockCluster_pertable_1);
        loadBalancer.balanceCluster(tableName, clusterState);
        tableName = TableName.valueOf((String)TABLE_NAME_2);
        clusterState = this.mockClusterServers(mockCluster_pertable_2);
        loadBalancer.balanceCluster(tableName, clusterState);
        tableName = TableName.valueOf((String)TABLE_NAME_NAMESPACE);
        clusterState = this.mockClusterServers(mockCluster_pertable_namespace);
        loadBalancer.balanceCluster(tableName, clusterState);
        String[] tableNames = new String[]{TABLE_NAME_1, TABLE_NAME_2, TABLE_NAME_NAMESPACE};
        Set<String> jmxMetrics = this.readJmxMetricsWithRetry();
        Set<String> expectedMetrics = this.getExpectedJmxMetrics(tableNames, functionNames);
        for (String expected : expectedMetrics) {
            Assert.assertTrue((String)("Metric " + expected + " can not be found in JMX in per-table mode."), (boolean)jmxMetrics.contains(expected));
        }
    }

    private Set<String> readJmxMetricsWithRetry() throws IOException {
        boolean count = false;
        for (int i = 0; i < 10; ++i) {
            Set<String> metrics = this.readJmxMetrics();
            if (metrics != null) {
                return metrics;
            }
            LOG.warn("Failed to get jmxmetrics... sleeping, retrying; " + i + " of " + 0 + " times");
            Threads.sleep((long)1000L);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> readJmxMetrics() throws IOException {
        JMXConnector connector = null;
        ObjectName target = null;
        MBeanServerConnection mb = null;
        try {
            connector = JMXConnectorFactory.connect(JMXListener.buildJMXServiceURL((int)connectorPort, (int)connectorPort));
            mb = connector.getMBeanServerConnection();
            Hashtable<String, String> pairs = new Hashtable<String, String>();
            pairs.put("service", "HBase");
            pairs.put("name", "Master");
            pairs.put("sub", "Balancer");
            target = new ObjectName("Hadoop", pairs);
            MBeanInfo beanInfo = mb.getMBeanInfo(target);
            HashSet<String> existingAttrs = new HashSet<String>();
            for (MBeanAttributeInfo attrInfo : beanInfo.getAttributes()) {
                existingAttrs.add(attrInfo.getName());
            }
            HashSet<String> hashSet = existingAttrs;
            return hashSet;
        }
        catch (Exception e) {
            LOG.warn("Failed to get bean!!! " + target, (Throwable)e);
            if (mb != null) {
                Set<ObjectInstance> instances = mb.queryMBeans(null, null);
                Iterator<ObjectInstance> iterator = instances.iterator();
                System.out.println("MBean Found:");
                while (iterator.hasNext()) {
                    ObjectInstance objectInstance = iterator.next();
                    System.out.println("Class Name: " + objectInstance.getClassName());
                    System.out.println("Object Name: " + objectInstance.getObjectName());
                }
            }
        }
        finally {
            if (connector != null) {
                try {
                    connector.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private Set<String> getExpectedJmxMetrics(String[] tableNames, String[] functionNames) {
        HashSet<String> ret = new HashSet<String>();
        for (String tableName : tableNames) {
            ret.add(StochasticLoadBalancer.composeAttributeName((String)tableName, (String)"Overall"));
            for (String functionName : functionNames) {
                String metricsName = StochasticLoadBalancer.composeAttributeName((String)tableName, (String)functionName);
                ret.add(metricsName);
            }
        }
        return ret;
    }

    private static void printMetrics(Set<String> metrics, String info) {
        if (null != info) {
            LOG.info("++++ ------ " + info + " ------");
        }
        LOG.info("++++ metrics count = " + metrics.size());
        for (String str : metrics) {
            LOG.info(" ++++ " + str);
        }
    }

    static {
        mockCluster_ensemble = new int[]{0, 1, 2, 3};
        mockCluster_pertable_1 = new int[]{0, 1, 2};
        mockCluster_pertable_2 = new int[]{3, 1, 1};
        mockCluster_pertable_namespace = new int[]{1, 3, 1};
        conf = null;
    }
}

