/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TestZooKeeper;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestZooKeeperACL {
    private static final Log LOG = LogFactory.getLog(TestZooKeeperACL.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static ZooKeeperWatcher zkw;
    private static boolean secureZKAvailable;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        File saslConfFile = File.createTempFile("tmp", "jaas.conf");
        FileWriter fwriter = new FileWriter(saslConfFile);
        fwriter.write("Server {\norg.apache.zookeeper.server.auth.DigestLoginModule required\nuser_hbase=\"secret\";\n};\nClient {\norg.apache.zookeeper.server.auth.DigestLoginModule required\nusername=\"hbase\"\npassword=\"secret\";\n};\n");
        fwriter.close();
        System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.getConfiguration().setInt("hbase.zookeeper.property.maxClientCnxns", 1000);
        try {
            TEST_UTIL.startMiniCluster();
        }
        catch (IOException e) {
            LOG.warn((Object)"Hadoop is missing HADOOP-7070", (Throwable)e);
            secureZKAvailable = false;
            return;
        }
        zkw = new ZooKeeperWatcher(new Configuration(TEST_UTIL.getConfiguration()), TestZooKeeper.class.getName(), null);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (!secureZKAvailable) {
            return;
        }
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        if (!secureZKAvailable) {
            return;
        }
        TEST_UTIL.ensureSomeRegionServersAvailable(2);
    }

    @Test(timeout=30000L)
    public void testHBaseRootZNodeACL() throws Exception {
        if (!secureZKAvailable) {
            return;
        }
        List acls = zkw.getRecoverableZooKeeper().getZooKeeper().getACL("/hbase", new Stat());
        Assert.assertEquals((long)acls.size(), (long)1L);
        Assert.assertEquals((Object)((ACL)acls.get(0)).getId().getScheme(), (Object)"sasl");
        Assert.assertEquals((Object)((ACL)acls.get(0)).getId().getId(), (Object)"hbase");
        Assert.assertEquals((long)((ACL)acls.get(0)).getPerms(), (long)31L);
    }

    @Test(timeout=30000L)
    public void testHBaseRootRegionServerZNodeACL() throws Exception {
        if (!secureZKAvailable) {
            return;
        }
        List acls = zkw.getRecoverableZooKeeper().getZooKeeper().getACL("/hbase/root-region-server", new Stat());
        Assert.assertEquals((long)acls.size(), (long)2L);
        boolean foundWorldReadableAcl = false;
        boolean foundHBaseOwnerAcl = false;
        for (int i = 0; i < 2; ++i) {
            if (((ACL)acls.get(i)).getId().getScheme().equals("world")) {
                Assert.assertEquals((Object)((ACL)acls.get(0)).getId().getId(), (Object)"anyone");
                Assert.assertEquals((long)((ACL)acls.get(0)).getPerms(), (long)1L);
                foundWorldReadableAcl = true;
                continue;
            }
            if (((ACL)acls.get(i)).getId().getScheme().equals("sasl")) {
                Assert.assertEquals((Object)((ACL)acls.get(1)).getId().getId(), (Object)"hbase");
                Assert.assertEquals((Object)((ACL)acls.get(1)).getId().getScheme(), (Object)"sasl");
                foundHBaseOwnerAcl = true;
                continue;
            }
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)foundWorldReadableAcl);
        Assert.assertTrue((boolean)foundHBaseOwnerAcl);
    }

    @Test(timeout=30000L)
    public void testHBaseMasterServerZNodeACL() throws Exception {
        if (!secureZKAvailable) {
            return;
        }
        List acls = zkw.getRecoverableZooKeeper().getZooKeeper().getACL("/hbase/master", new Stat());
        Assert.assertEquals((long)acls.size(), (long)2L);
        boolean foundWorldReadableAcl = false;
        boolean foundHBaseOwnerAcl = false;
        for (int i = 0; i < 2; ++i) {
            if (((ACL)acls.get(i)).getId().getScheme().equals("world")) {
                Assert.assertEquals((Object)((ACL)acls.get(0)).getId().getId(), (Object)"anyone");
                Assert.assertEquals((long)((ACL)acls.get(0)).getPerms(), (long)1L);
                foundWorldReadableAcl = true;
                continue;
            }
            if (((ACL)acls.get(i)).getId().getScheme().equals("sasl")) {
                Assert.assertEquals((Object)((ACL)acls.get(1)).getId().getId(), (Object)"hbase");
                Assert.assertEquals((Object)((ACL)acls.get(1)).getId().getScheme(), (Object)"sasl");
                foundHBaseOwnerAcl = true;
                continue;
            }
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)foundWorldReadableAcl);
        Assert.assertTrue((boolean)foundHBaseOwnerAcl);
    }

    @Test(timeout=30000L)
    public void testHBaseIDZNodeACL() throws Exception {
        if (!secureZKAvailable) {
            return;
        }
        List acls = zkw.getRecoverableZooKeeper().getZooKeeper().getACL("/hbase/hbaseid", new Stat());
        Assert.assertEquals((long)acls.size(), (long)2L);
        boolean foundWorldReadableAcl = false;
        boolean foundHBaseOwnerAcl = false;
        for (int i = 0; i < 2; ++i) {
            if (((ACL)acls.get(i)).getId().getScheme().equals("world")) {
                Assert.assertEquals((Object)((ACL)acls.get(0)).getId().getId(), (Object)"anyone");
                Assert.assertEquals((long)((ACL)acls.get(0)).getPerms(), (long)1L);
                foundWorldReadableAcl = true;
                continue;
            }
            if (((ACL)acls.get(i)).getId().getScheme().equals("sasl")) {
                Assert.assertEquals((Object)((ACL)acls.get(1)).getId().getId(), (Object)"hbase");
                Assert.assertEquals((Object)((ACL)acls.get(1)).getId().getScheme(), (Object)"sasl");
                foundHBaseOwnerAcl = true;
                continue;
            }
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)foundWorldReadableAcl);
        Assert.assertTrue((boolean)foundHBaseOwnerAcl);
    }

    @Test
    public void testOutsideHBaseNodeACL() throws Exception {
        if (!secureZKAvailable) {
            return;
        }
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/testACLNode");
        List acls = zkw.getRecoverableZooKeeper().getZooKeeper().getACL("/testACLNode", new Stat());
        Assert.assertEquals((long)acls.size(), (long)1L);
        Assert.assertEquals((Object)((ACL)acls.get(0)).getId().getScheme(), (Object)"sasl");
        Assert.assertEquals((Object)((ACL)acls.get(0)).getId().getId(), (Object)"hbase");
        Assert.assertEquals((long)((ACL)acls.get(0)).getPerms(), (long)31L);
    }

    @Test
    public void testIsZooKeeperSecure() throws Exception {
        boolean testJaasConfig = ZKUtil.isSecureZooKeeper((Configuration)new Configuration(TEST_UTIL.getConfiguration()));
        Assert.assertEquals((Object)testJaasConfig, (Object)secureZKAvailable);
        File saslConfFile = File.createTempFile("tmp", "fakeJaas.conf");
        FileWriter fwriter = new FileWriter(saslConfFile);
        fwriter.write("");
        fwriter.close();
        System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        testJaasConfig = ZKUtil.isSecureZooKeeper((Configuration)new Configuration(TEST_UTIL.getConfiguration()));
        Assert.assertEquals((Object)testJaasConfig, (Object)false);
        saslConfFile.delete();
    }

    @Test
    public void testIsZooKeeperSecureWithProgrammaticConfig() throws Exception {
        javax.security.auth.login.Configuration.setConfiguration(new DummySecurityConfiguration());
        Configuration config = new Configuration(HBaseConfiguration.create());
        boolean testJaasConfig = ZKUtil.isSecureZooKeeper((Configuration)config);
        Assert.assertEquals((Object)testJaasConfig, (Object)false);
        config.set("hbase.security.authentication", "kerberos");
        testJaasConfig = ZKUtil.isSecureZooKeeper((Configuration)config);
        Assert.assertEquals((Object)testJaasConfig, (Object)false);
        config.set("hbase.zookeeper.client.keytab.file", "/dummy/file");
        config.set("hbase.zookeeper.client.kerberos.principal", "dummy");
        config.set("hbase.zookeeper.server.keytab.file", "/dummy/file");
        config.set("hbase.zookeeper.server.kerberos.principal", "dummy");
        testJaasConfig = ZKUtil.isSecureZooKeeper((Configuration)config);
        Assert.assertEquals((Object)true, (Object)testJaasConfig);
    }

    private static class DummySecurityConfiguration
    extends javax.security.auth.login.Configuration {
        private DummySecurityConfiguration() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return null;
        }
    }
}

