/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.regionserver.wal.SyncFuture;
import org.apache.hadoop.hbase.regionserver.wal.SyncFutureCache;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestSyncFutureCache {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSyncFutureCacheLifeCycle() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        final SyncFutureCache cache = new SyncFutureCache(conf);
        try {
            SyncFuture future0 = cache.getIfPresentOrNew().reset(0L);
            Assert.assertNotNull((Object)future0);
            SyncFuture future1 = cache.getIfPresentOrNew().reset(1L);
            Assert.assertNotNull((Object)future1);
            Assert.assertNotSame((Object)future0, (Object)future1);
            cache.offer(future1);
            cache.offer(future0);
            SyncFuture future3 = cache.getIfPresentOrNew();
            Assert.assertEquals((Object)future3, (Object)future0);
            final SyncFuture[] future4 = new SyncFuture[1];
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    future4[0] = cache.getIfPresentOrNew().reset(4L);
                }
            });
            t.start();
            t.join();
            Assert.assertNotNull((Object)future4[0]);
            Assert.assertNotSame((Object)future3, (Object)future4[0]);
            cache.offer(future3);
            cache.offer(future4[0]);
        }
        finally {
            cache.clear();
        }
    }
}

