/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.Message;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.QosTestHelper;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.AnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestQosFunction
extends QosTestHelper {
    private Configuration conf;
    private RSRpcServices rpcServices;
    private AnnotationReadingPriorityFunction qosFunction;

    @Before
    public void setUp() {
        this.conf = HBaseConfiguration.create();
        this.rpcServices = (RSRpcServices)Mockito.mock(RSRpcServices.class);
        Mockito.when((Object)this.rpcServices.getConfiguration()).thenReturn((Object)this.conf);
        this.qosFunction = new AnnotationReadingPriorityFunction(this.rpcServices, RSRpcServices.class);
    }

    @Test
    public void testPriority() {
        this.checkMethod(this.conf, "ReplicateWALEntry", 5, this.qosFunction);
        this.checkMethod(this.conf, "OpenRegion", 100, this.qosFunction);
        this.checkMethod(this.conf, "Multi", 0, this.qosFunction, (Message)ClientProtos.MultiRequest.getDefaultInstance());
    }

    @Test
    public void testAnnotations() {
        this.checkMethod(this.conf, "CloseRegion", 100, this.qosFunction);
        this.checkMethod(this.conf, "CompactRegion", 100, this.qosFunction);
        this.checkMethod(this.conf, "FlushRegion", 100, this.qosFunction);
    }
}

