/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceExistException;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.master.procedure.CreateNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCreateNamespaceProcedure {
    private static final Log LOG = LogFactory.getLog(TestCreateNamespaceProcedure.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestCreateNamespaceProcedure.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
    }

    @After
    public void tearDown() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
    }

    @Test(timeout=60000L)
    public void testCreateNamespace() throws Exception {
        NamespaceDescriptor nsd = NamespaceDescriptor.create((String)"testCreateNamespace").build();
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = procExec.submitProcedure((Procedure)new CreateNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsd));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        this.validateNamespaceCreated(nsd);
    }

    @Test(timeout=60000L)
    public void testCreateSameNamespaceTwice() throws Exception {
        NamespaceDescriptor nsd = NamespaceDescriptor.create((String)"testCreateSameNamespaceTwice").build();
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId1 = procExec.submitProcedure((Procedure)new CreateNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsd));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId1);
        long procId2 = procExec.submitProcedure((Procedure)new CreateNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsd));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId2);
        ProcedureInfo result = procExec.getResult(procId2);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Create namespace failed with exception: " + result.getExceptionFullMessage()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((ProcedureInfo)result) instanceof NamespaceExistException));
    }

    @Test(timeout=60000L)
    public void testCreateSystemNamespace() throws Exception {
        NamespaceDescriptor nsd = UTIL.getHBaseAdmin().getNamespaceDescriptor(NamespaceDescriptor.SYSTEM_NAMESPACE.getName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = procExec.submitProcedure((Procedure)new CreateNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsd));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureInfo result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Create namespace failed with exception: " + result.getExceptionFullMessage()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((ProcedureInfo)result) instanceof NamespaceExistException));
    }

    @Test(timeout=60000L)
    public void testCreateNamespaceWithInvalidRegionCount() throws Exception {
        NamespaceDescriptor nsd = NamespaceDescriptor.create((String)"testCreateNamespaceWithInvalidRegionCount").build();
        String nsKey = "hbase.namespace.quota.maxregions";
        String nsValue = "-1";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        nsd.setConfiguration("hbase.namespace.quota.maxregions", "-1");
        long procId = procExec.submitProcedure((Procedure)new CreateNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsd));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureInfo result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Create namespace failed with exception: " + result.getExceptionFullMessage()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((ProcedureInfo)result) instanceof ConstraintException));
    }

    @Test(timeout=60000L)
    public void testCreateNamespaceWithInvalidTableCount() throws Exception {
        NamespaceDescriptor nsd = NamespaceDescriptor.create((String)"testCreateNamespaceWithInvalidTableCount").build();
        String nsKey = "hbase.namespace.quota.maxtables";
        String nsValue = "-1";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        nsd.setConfiguration("hbase.namespace.quota.maxtables", "-1");
        long procId = procExec.submitProcedure((Procedure)new CreateNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsd));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureInfo result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Create namespace failed with exception: " + result.getExceptionFullMessage()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((ProcedureInfo)result) instanceof ConstraintException));
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecution() throws Exception {
        NamespaceDescriptor nsd = NamespaceDescriptor.create((String)"testRecoveryAndDoubleExecution").build();
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new CreateNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsd));
        int numberOfSteps = MasterProcedureProtos.CreateNamespaceState.values().length;
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.CreateNamespaceState.values());
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        this.validateNamespaceCreated(nsd);
    }

    @Test(timeout=60000L)
    public void testRollbackAndDoubleExecution() throws Exception {
        NamespaceDescriptor nsd = NamespaceDescriptor.create((String)"testRollbackAndDoubleExecution").build();
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new CreateNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsd));
        int numberOfSteps = MasterProcedureProtos.CreateNamespaceState.values().length - 2;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.CreateNamespaceState.values());
        try {
            NamespaceDescriptor nsDescriptor = UTIL.getHBaseAdmin().getNamespaceDescriptor(nsd.getName());
            Assert.assertNull((Object)nsDescriptor);
        }
        catch (NamespaceNotFoundException nsnfe) {
            LOG.info((Object)("The namespace " + nsd.getName() + " is not created."));
        }
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    private void validateNamespaceCreated(NamespaceDescriptor nsd) throws IOException {
        NamespaceDescriptor createdNsDescriptor = UTIL.getHBaseAdmin().getNamespaceDescriptor(nsd.getName());
        Assert.assertNotNull((Object)createdNsDescriptor);
    }
}

