/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.master.cleaner.ReplicationZKNodeCleaner;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesZKImpl;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestReplicationZKNodeCleaner {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final String ID_ONE = "1";
    private final String SERVER_ONE = "server1";
    private final String ID_TWO = "2";
    private final String SERVER_TWO = "server2";
    private final Configuration conf = TEST_UTIL.getConfiguration();
    private final ZooKeeperWatcher zkw = new ZooKeeperWatcher(this.conf, "TestReplicationZKNodeCleaner", null);
    private final ReplicationQueues repQueues = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)this.zkw, (Configuration)this.conf, null);

    public TestReplicationZKNodeCleaner() throws Exception {
        Assert.assertTrue((boolean)(this.repQueues instanceof ReplicationQueuesZKImpl));
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.master.cleaner.interval", 10000);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testReplicationZKNodeCleaner() throws Exception {
        this.repQueues.init("server1");
        this.repQueues.addLog("1", "file1");
        ReplicationZKNodeCleaner cleaner = new ReplicationZKNodeCleaner(this.conf, this.zkw, null);
        Map undeletedQueues = cleaner.getUnDeletedQueues();
        Assert.assertEquals((long)1L, (long)undeletedQueues.size());
        Assert.assertTrue((boolean)undeletedQueues.containsKey("server1"));
        Assert.assertEquals((long)1L, (long)((List)undeletedQueues.get("server1")).size());
        Assert.assertTrue((boolean)((List)undeletedQueues.get("server1")).contains("1"));
        this.repQueues.addLog("2-server2", "file2");
        undeletedQueues = cleaner.getUnDeletedQueues();
        Assert.assertEquals((long)1L, (long)undeletedQueues.size());
        Assert.assertTrue((boolean)undeletedQueues.containsKey("server1"));
        Assert.assertEquals((long)2L, (long)((List)undeletedQueues.get("server1")).size());
        Assert.assertTrue((boolean)((List)undeletedQueues.get("server1")).contains("1"));
        Assert.assertTrue((boolean)((List)undeletedQueues.get("server1")).contains("2-server2"));
        cleaner.removeQueues(undeletedQueues);
        undeletedQueues = cleaner.getUnDeletedQueues();
        Assert.assertEquals((long)0L, (long)undeletedQueues.size());
    }

    @Test
    public void testReplicationZKNodeCleanerChore() throws Exception {
        this.repQueues.init("server1");
        this.repQueues.addLog("1", "file1");
        this.repQueues.addLog("2-server2", "file2");
        Thread.sleep(20000L);
        ReplicationZKNodeCleaner cleaner = new ReplicationZKNodeCleaner(this.conf, this.zkw, null);
        Assert.assertEquals((long)0L, (long)cleaner.getUnDeletedQueues().size());
    }
}

