/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.TestMasterMetrics;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestGetReplicationLoad {
    private static final Logger LOG = LoggerFactory.getLogger(TestGetReplicationLoad.class);
    private static HBaseTestingUtility TEST_UTIL;
    private static MiniHBaseCluster cluster;
    private static HMaster master;
    private static ReplicationAdmin admin;
    private static final String ID_1 = "1";
    private static final String ID_2 = "2";
    private static final String KEY_1 = "127.0.0.1:2181:/hbase";
    private static final String KEY_2 = "127.0.0.1:2181:/hbase2";

    @BeforeClass
    public static void startCluster() throws Exception {
        LOG.info("Starting cluster");
        TEST_UTIL = new HBaseTestingUtility();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.replication", true);
        TEST_UTIL.startMiniCluster(1, 1, 1, null, TestMasterMetrics.MyMaster.class, null);
        cluster = TEST_UTIL.getHBaseCluster();
        LOG.info("Waiting for active/ready master");
        cluster.waitForActiveAndReadyMaster();
        master = cluster.getMaster();
        admin = new ReplicationAdmin(conf);
    }

    @AfterClass
    public static void after() throws Exception {
        if (admin != null) {
            admin.close();
        }
        if (TEST_UTIL != null) {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    @Test
    public void testGetReplicationMetrics() throws Exception {
        String peer1 = "test1";
        String peer2 = "test2";
        long ageOfLastShippedOp = 2L;
        long replicationLag = 3L;
        long timeStampOfLastShippedOp = 4L;
        int sizeOfLogQueue = 5;
        RegionServerStatusProtos.RegionServerReportRequest.Builder request = RegionServerStatusProtos.RegionServerReportRequest.newBuilder();
        ServerName serverName = cluster.getMaster(0).getServerName();
        request.setServer(ProtobufUtil.toServerName((ServerName)serverName));
        ClusterStatusProtos.ReplicationLoadSource rload1 = ClusterStatusProtos.ReplicationLoadSource.newBuilder().setPeerID(peer1).setAgeOfLastShippedOp(ageOfLastShippedOp).setReplicationLag(replicationLag).setTimeStampOfLastShippedOp(timeStampOfLastShippedOp).setSizeOfLogQueue(sizeOfLogQueue).build();
        ClusterStatusProtos.ReplicationLoadSource rload2 = ClusterStatusProtos.ReplicationLoadSource.newBuilder().setPeerID(peer2).setAgeOfLastShippedOp(ageOfLastShippedOp + 1L).setReplicationLag(replicationLag + 1L).setTimeStampOfLastShippedOp(timeStampOfLastShippedOp + 1L).setSizeOfLogQueue(sizeOfLogQueue + 1).build();
        ClusterStatusProtos.ServerLoad sl = ClusterStatusProtos.ServerLoad.newBuilder().addReplLoadSource(rload1).addReplLoadSource(rload2).build();
        request.setLoad(sl);
        ReplicationPeerConfig peerConfig_1 = new ReplicationPeerConfig();
        peerConfig_1.setClusterKey(KEY_1);
        ReplicationPeerConfig peerConfig_2 = new ReplicationPeerConfig();
        peerConfig_2.setClusterKey(KEY_2);
        admin.addPeer(ID_1, peerConfig_1);
        admin.addPeer(ID_2, peerConfig_2);
        master.getMasterRpcServices().regionServerReport(null, request.build());
        HashMap replicationLoad = master.getReplicationLoad(new ServerName[]{serverName});
        Assert.assertEquals((String)"peer size ", (long)2L, (long)replicationLoad.size());
        Assert.assertEquals((String)"load size ", (long)1L, (long)((List)replicationLoad.get(peer1)).size());
        Assert.assertEquals((String)"log queue size of peer1", (long)sizeOfLogQueue, (long)((ReplicationLoadSource)((Pair)((List)replicationLoad.get(peer1)).get(0)).getSecond()).getSizeOfLogQueue());
        Assert.assertEquals((String)"replication lag of peer2", (long)(replicationLag + 1L), (long)((ReplicationLoadSource)((Pair)((List)replicationLoad.get(peer2)).get(0)).getSecond()).getReplicationLag());
        master.stopMaster();
    }

    public static class MyMaster
    extends HMaster {
        public MyMaster(Configuration conf, CoordinatedStateManager csm) throws IOException, KeeperException, InterruptedException {
            super(conf, csm);
        }

        protected void tryRegionServerReport(long reportStartTime, long reportEndTime) {
        }
    }
}

