/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.decode.timestamp;

import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.util.vint.UFIntTool;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class TimestampDecoder {
    protected PrefixTreeBlockMeta blockMeta;
    protected ByteBuff block;

    public void initOnBlock(PrefixTreeBlockMeta blockMeta, ByteBuff block) {
        this.block = block;
        this.blockMeta = blockMeta;
    }

    public long getLong(int index) {
        if (this.blockMeta.getTimestampIndexWidth() == 0) {
            return this.blockMeta.getMinTimestamp();
        }
        int startIndex = this.blockMeta.getAbsoluteTimestampOffset() + this.blockMeta.getTimestampDeltaWidth() * index;
        long delta = UFIntTool.fromBytes(this.block, startIndex, this.blockMeta.getTimestampDeltaWidth());
        return this.blockMeta.getMinTimestamp() + delta;
    }
}

