/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class PoolMap<K, V>
implements Map<K, V> {
    private PoolType poolType;
    private int poolMaxSize;
    private Map<K, Pool<V>> pools = new ConcurrentHashMap<K, Pool<V>>();

    public PoolMap(PoolType poolType) {
        this.poolType = poolType;
    }

    public PoolMap(PoolType poolType, int poolMaxSize) {
        this.poolType = poolType;
        this.poolMaxSize = poolMaxSize;
    }

    @Override
    public V get(Object key) {
        Pool<V> pool = this.pools.get(key);
        return pool != null ? (V)pool.get() : null;
    }

    @Override
    public V put(K key, V value) {
        Pool<V> pool = this.pools.get(key);
        if (pool == null) {
            pool = this.createPool();
            this.pools.put(key, pool);
        }
        return pool != null ? (V)pool.put(value) : null;
    }

    @Override
    public V remove(Object key) {
        Pool<V> pool = this.pools.remove(key);
        if (pool != null) {
            this.removeValue(key, pool.get());
        }
        return null;
    }

    public boolean removeValue(K key, V value) {
        Pool<V> pool = this.pools.get(key);
        boolean res = false;
        if (pool != null && (res = pool.remove(value)) && pool.size() == 0) {
            this.pools.remove(key);
        }
        return res;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        for (Pool<V> pool : this.pools.values()) {
            Collection<V> poolValues = pool.values();
            if (poolValues == null) continue;
            values.addAll(poolValues);
        }
        return values;
    }

    public Collection<V> values(K key) {
        Collection<V> poolValues;
        ArrayList<V> values = new ArrayList<V>();
        Pool<V> pool = this.pools.get(key);
        if (pool != null && (poolValues = pool.values()) != null) {
            values.addAll(poolValues);
        }
        return values;
    }

    @Override
    public boolean isEmpty() {
        return this.pools.isEmpty();
    }

    @Override
    public int size() {
        return this.pools.size();
    }

    public int size(K key) {
        Pool<V> pool = this.pools.get(key);
        return pool != null ? pool.size() : 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.pools.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        for (Pool<V> pool : this.pools.values()) {
            if (!value.equals(pool.get())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        for (Pool<V> pool : this.pools.values()) {
            pool.clear();
        }
        this.pools.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.pools.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, Pool<V>> poolEntry : this.pools.entrySet()) {
            final K poolKey = poolEntry.getKey();
            final Pool<V> pool = poolEntry.getValue();
            if (pool == null) continue;
            for (final V poolValue : pool.values()) {
                entries.add(new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return poolKey;
                    }

                    @Override
                    public V getValue() {
                        return poolValue;
                    }

                    @Override
                    public V setValue(V value) {
                        return pool.put(value);
                    }
                });
            }
        }
        return entries;
    }

    protected Pool<V> createPool() {
        switch (this.poolType) {
            case Reusable: {
                return new ReusablePool(this.poolMaxSize);
            }
            case RoundRobin: {
                return new RoundRobinPool(this.poolMaxSize);
            }
            case ThreadLocal: {
                return new ThreadLocalPool();
            }
        }
        return null;
    }

    static class ThreadLocalPool<R>
    extends ThreadLocal<R>
    implements Pool<R> {
        private static final Map<ThreadLocalPool<?>, AtomicInteger> poolSizes = new HashMap();

        @Override
        public R put(R resource) {
            Object previousResource = this.get();
            if (previousResource == null) {
                AtomicInteger poolSize = poolSizes.get(this);
                if (poolSize == null) {
                    poolSize = new AtomicInteger(0);
                    poolSizes.put(this, poolSize);
                }
                poolSize.incrementAndGet();
            }
            this.set(resource);
            return (R)previousResource;
        }

        @Override
        public void remove() {
            super.remove();
            AtomicInteger poolSize = poolSizes.get(this);
            if (poolSize != null) {
                poolSize.decrementAndGet();
            }
        }

        @Override
        public int size() {
            AtomicInteger poolSize = poolSizes.get(this);
            return poolSize != null ? poolSize.get() : 0;
        }

        @Override
        public boolean remove(R resource) {
            Object previousResource = super.get();
            if (resource != null && resource.equals(previousResource)) {
                this.remove();
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            super.remove();
        }

        @Override
        public Collection<R> values() {
            ArrayList values = new ArrayList();
            values.add(this.get());
            return values;
        }
    }

    static class RoundRobinPool<R>
    extends CopyOnWriteArrayList<R>
    implements Pool<R> {
        private int maxSize;
        private int nextResource = 0;

        public RoundRobinPool(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public R put(R resource) {
            if (super.size() < this.maxSize) {
                this.add(resource);
            }
            return null;
        }

        @Override
        public R get() {
            if (super.size() < this.maxSize) {
                return null;
            }
            this.nextResource %= super.size();
            Object resource = this.get(this.nextResource++);
            return (R)resource;
        }

        @Override
        public Collection<R> values() {
            return this;
        }
    }

    public static class ReusablePool<R>
    extends ConcurrentLinkedQueue<R>
    implements Pool<R> {
        private int maxSize;

        public ReusablePool(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public R get() {
            return (R)this.poll();
        }

        @Override
        public R put(R resource) {
            if (super.size() < this.maxSize) {
                this.add(resource);
            }
            return null;
        }

        @Override
        public Collection<R> values() {
            return this;
        }
    }

    public static enum PoolType {
        Reusable,
        ThreadLocal,
        RoundRobin;


        public static PoolType valueOf(String poolTypeName, PoolType defaultPoolType, PoolType ... allowedPoolTypes) {
            PoolType poolType = PoolType.fuzzyMatch(poolTypeName);
            if (poolType != null) {
                boolean allowedType = false;
                if (poolType.equals((Object)defaultPoolType)) {
                    allowedType = true;
                } else if (allowedPoolTypes != null) {
                    for (PoolType allowedPoolType : allowedPoolTypes) {
                        if (!poolType.equals((Object)allowedPoolType)) continue;
                        allowedType = true;
                        break;
                    }
                }
                if (!allowedType) {
                    poolType = null;
                }
            }
            return poolType != null ? poolType : defaultPoolType;
        }

        public static String fuzzyNormalize(String name) {
            return name != null ? name.replaceAll("-", "").trim().toLowerCase(Locale.ROOT) : "";
        }

        public static PoolType fuzzyMatch(String name) {
            for (PoolType poolType : PoolType.values()) {
                if (!PoolType.fuzzyNormalize(name).equals(PoolType.fuzzyNormalize(poolType.name()))) continue;
                return poolType;
            }
            return null;
        }
    }

    protected static interface Pool<R> {
        public R get();

        public R put(R var1);

        public boolean remove(R var1);

        public void clear();

        public Collection<R> values();

        public int size();
    }
}

