/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ClientSnapshotDescriptionUtils {
    public static void assertSnapshotRequestIsValid(SnapshotProtos.SnapshotDescription snapshot) throws IllegalArgumentException {
        TableName tableName;
        TableName.isLegalTableQualifierName((byte[])Bytes.toBytes((String)snapshot.getName()), (boolean)true);
        if (snapshot.hasTable() && (tableName = TableName.valueOf((String)snapshot.getTable())).isSystemTable()) {
            throw new IllegalArgumentException("System table snapshots are not allowed");
        }
    }

    public static String toString(SnapshotProtos.SnapshotDescription ssd) {
        if (ssd == null) {
            return null;
        }
        return "{ ss=" + ssd.getName() + " table=" + (ssd.hasTable() ? TableName.valueOf((String)ssd.getTable()) : "") + " type=" + ssd.getType() + " }";
    }
}

