/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.zookeeper.PendingWatcher;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;

@InterfaceAudience.Private
public class ZooKeeperWatcher
implements Watcher,
Abortable,
Closeable {
    private static final Log LOG = LogFactory.getLog(ZooKeeperWatcher.class);
    private String prefix;
    private String identifier;
    private String quorum;
    private final RecoverableZooKeeper recoverableZooKeeper;
    protected Abortable abortable;
    private boolean aborted = false;
    private final List<ZooKeeperListener> listeners = new CopyOnWriteArrayList<ZooKeeperListener>();
    public CountDownLatch saslLatch = new CountDownLatch(1);
    public String baseZNode;
    private Map<Integer, String> metaReplicaZnodes = new HashMap<Integer, String>();
    public String rsZNode;
    public String drainingZNode;
    private String masterAddressZNode;
    public String backupMasterAddressesZNode;
    public String clusterStateZNode;
    public String assignmentZNode;
    public String tableZNode;
    public String clusterIdZNode;
    public String splitLogZNode;
    public String balancerZNode;
    private String regionNormalizerZNode;
    private String switchZNode;
    public String tableLockZNode;
    public String recoveringRegionsZNode;
    public static String namespaceZNode = "namespace";
    public static final ArrayList<ACL> CREATOR_ALL_AND_WORLD_READABLE = new ArrayList<ACL>(){
        {
            this.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
            this.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
        }
    };
    public static final String META_ZNODE_PREFIX = "meta-region-server";
    private final Configuration conf;
    private static final Pattern NAME_PATTERN = Pattern.compile("([^/@]*)(/([^/@]*))?@([^/@]*)");

    public ZooKeeperWatcher(Configuration conf, String identifier, Abortable abortable) throws ZooKeeperConnectionException, IOException {
        this(conf, identifier, abortable, false);
    }

    public ZooKeeperWatcher(Configuration conf, String identifier, Abortable abortable, boolean canCreateBaseZNode) throws IOException, ZooKeeperConnectionException {
        this.conf = conf;
        this.quorum = ZKConfig.getZKQuorumServersString((Configuration)conf);
        this.prefix = identifier;
        this.identifier = identifier + "0x0";
        this.abortable = abortable;
        this.setNodeNames(conf);
        PendingWatcher pendingWatcher = new PendingWatcher();
        this.recoverableZooKeeper = ZKUtil.connect(conf, this.quorum, pendingWatcher, identifier);
        pendingWatcher.prepare(this);
        if (canCreateBaseZNode) {
            this.createBaseZNodes();
        }
    }

    private void createBaseZNodes() throws ZooKeeperConnectionException {
        try {
            ZKUtil.createWithParents(this, this.baseZNode);
            if (this.conf.getBoolean("hbase.assignment.usezk", true)) {
                ZKUtil.createAndFailSilent(this, this.assignmentZNode);
            }
            ZKUtil.createAndFailSilent(this, this.rsZNode);
            ZKUtil.createAndFailSilent(this, this.drainingZNode);
            ZKUtil.createAndFailSilent(this, this.tableZNode);
            ZKUtil.createAndFailSilent(this, this.splitLogZNode);
            ZKUtil.createAndFailSilent(this, this.backupMasterAddressesZNode);
            ZKUtil.createAndFailSilent(this, this.tableLockZNode);
            ZKUtil.createAndFailSilent(this, this.recoveringRegionsZNode);
        }
        catch (KeeperException e) {
            throw new ZooKeeperConnectionException(this.prefix("Unexpected KeeperException creating base node"), (Exception)((Object)e));
        }
    }

    public boolean isClientReadable(String node) {
        return node.equals(this.baseZNode) || this.isAnyMetaReplicaZnode(node) || node.equals(this.getMasterAddressZNode()) || node.equals(this.clusterIdZNode) || node.equals(this.rsZNode) || node.equals(this.tableZNode) || node.startsWith(this.tableZNode + "/");
    }

    public void checkAndSetZNodeAcls() {
        if (!ZKUtil.isSecureZooKeeper(this.getConfiguration())) {
            LOG.info((Object)"not a secure deployment, proceeding");
            return;
        }
        try {
            List<ACL> actualAcls = this.recoverableZooKeeper.getAcl(this.baseZNode, new Stat());
            if (!this.isBaseZnodeAclSetup(actualAcls)) {
                LOG.info((Object)"setting znode ACLs");
                this.setZnodeAclsRecursive(this.baseZNode);
            }
        }
        catch (KeeperException.NoNodeException nne) {
            return;
        }
        catch (InterruptedException ie) {
            this.interruptedException(ie);
        }
        catch (IOException | KeeperException e) {
            LOG.warn((Object)"Received exception while checking and setting zookeeper ACLs", e);
        }
    }

    private void setZnodeAclsRecursive(String znode) throws KeeperException, InterruptedException {
        List<String> children = this.recoverableZooKeeper.getChildren(znode, false);
        for (String child : children) {
            this.setZnodeAclsRecursive(ZKUtil.joinZNode(znode, child));
        }
        ArrayList<ACL> acls = ZKUtil.createACL(this, znode, true);
        LOG.info((Object)("Setting ACLs for znode:" + znode + " , acl:" + acls));
        this.recoverableZooKeeper.setAcl(znode, acls, -1);
    }

    private boolean isBaseZnodeAclSetup(List<ACL> acls) throws IOException {
        String[] superUsers;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Checking znode ACLs");
        }
        if ((superUsers = this.conf.getStrings("hbase.superuser")) != null && !this.checkACLForSuperUsers(superUsers, acls)) {
            return false;
        }
        String hbaseUser = UserGroupInformation.getCurrentUser().getShortUserName();
        if (acls.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"ACL is empty");
            }
            return false;
        }
        for (ACL acl : acls) {
            int perms = acl.getPerms();
            Id id = acl.getId();
            if (ZooDefs.Ids.ANYONE_ID_UNSAFE.equals((Object)id)) {
                if (perms == 1) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("permissions for '%s' are not correct: have 0x%x, want 0x%x", id, perms, 1));
                }
                return false;
            }
            if (superUsers != null && ZooKeeperWatcher.isSuperUserId(superUsers, id)) {
                if (perms == 31) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("permissions for '%s' are not correct: have 0x%x, want 0x%x", id, perms, 31));
                }
                return false;
            }
            if ("sasl".equals(id.getScheme())) {
                String name = id.getId();
                Matcher match = NAME_PATTERN.matcher(name);
                if (match.matches()) {
                    name = match.group(1);
                }
                if (name.equals(hbaseUser)) {
                    if (perms == 31) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("permissions for '%s' are not correct: have 0x%x, want 0x%x", id, perms, 31));
                    }
                    return false;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Unexpected shortname in SASL ACL: " + id));
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("unexpected ACL id '" + id + "'"));
            }
            return false;
        }
        return true;
    }

    private boolean checkACLForSuperUsers(String[] superUsers, List<ACL> acls) {
        for (String user : superUsers) {
            boolean hasAccess = false;
            if (AuthUtil.isGroupPrincipal((String)user)) continue;
            for (ACL acl : acls) {
                if (!user.equals(acl.getId().getId())) continue;
                if (acl.getPerms() == 31) {
                    hasAccess = true;
                    break;
                }
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)String.format("superuser '%s' does not have correct permissions: have 0x%x, want 0x%x", acl.getId().getId(), acl.getPerms(), 31));
                break;
            }
            if (hasAccess) continue;
            return false;
        }
        return true;
    }

    public static boolean isSuperUserId(String[] superUsers, Id id) {
        for (String user : superUsers) {
            if (AuthUtil.isGroupPrincipal((String)user) || !new Id("sasl", user).equals((Object)id)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.identifier + ", quorum=" + this.quorum + ", baseZNode=" + this.baseZNode;
    }

    public String prefix(String str) {
        return this.toString() + " " + str;
    }

    private void setNodeNames(Configuration conf) {
        this.baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        this.metaReplicaZnodes.put(0, ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.metaserver", META_ZNODE_PREFIX)));
        int numMetaReplicas = conf.getInt("hbase.meta.replica.count", 1);
        for (int i = 1; i < numMetaReplicas; ++i) {
            String str = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.metaserver", META_ZNODE_PREFIX) + "-" + i);
            this.metaReplicaZnodes.put(i, str);
        }
        this.rsZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.rs", "rs"));
        this.drainingZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.draining.rs", "draining"));
        this.masterAddressZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.master", "master"));
        this.backupMasterAddressesZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.backup.masters", "backup-masters"));
        this.clusterStateZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.state", "running"));
        this.assignmentZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.unassigned", "region-in-transition"));
        this.tableZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.tableEnableDisable", "table"));
        this.clusterIdZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.clusterId", "hbaseid"));
        this.splitLogZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.splitlog", "splitWAL"));
        this.balancerZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.balancer", "balancer"));
        this.regionNormalizerZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.regionNormalizer", "normalizer"));
        this.switchZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.switch", "switch"));
        this.tableLockZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.tableLock", "table-lock"));
        this.recoveringRegionsZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.recovering.regions", "recovering-regions"));
        namespaceZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.namespace", "namespace"));
    }

    public boolean isAnyMetaReplicaZnode(String node) {
        return this.metaReplicaZnodes.values().contains(node);
    }

    public boolean isDefaultMetaReplicaZnode(String node) {
        return this.getZNodeForReplica(0).equals(node);
    }

    public List<String> getMetaReplicaNodes() throws KeeperException {
        List<String> childrenOfBaseNode = ZKUtil.listChildrenNoWatch(this, this.baseZNode);
        ArrayList<String> metaReplicaNodes = new ArrayList<String>(2);
        if (childrenOfBaseNode != null) {
            String pattern = this.conf.get("zookeeper.znode.metaserver", META_ZNODE_PREFIX);
            for (String child : childrenOfBaseNode) {
                if (!child.startsWith(pattern)) continue;
                metaReplicaNodes.add(child);
            }
        }
        return metaReplicaNodes;
    }

    public String getZNodeForReplica(int replicaId) {
        String str = this.metaReplicaZnodes.get(replicaId);
        if (str == null) {
            str = ZKUtil.joinZNode(this.baseZNode, this.conf.get("zookeeper.znode.metaserver", META_ZNODE_PREFIX) + "-" + replicaId);
        }
        return str;
    }

    public int getMetaReplicaIdFromZnode(String znode) {
        String pattern = this.conf.get("zookeeper.znode.metaserver", META_ZNODE_PREFIX);
        if (znode.equals(pattern)) {
            return 0;
        }
        String nonDefaultPattern = pattern + "-";
        return Integer.parseInt(znode.substring(nonDefaultPattern.length()));
    }

    public void registerListener(ZooKeeperListener listener) {
        this.listeners.add(listener);
    }

    public void registerListenerFirst(ZooKeeperListener listener) {
        this.listeners.add(0, listener);
    }

    public void unregisterListener(ZooKeeperListener listener) {
        this.listeners.remove(listener);
    }

    public void unregisterAllListeners() {
        this.listeners.clear();
    }

    public List<ZooKeeperListener> getListeners() {
        return new ArrayList<ZooKeeperListener>(this.listeners);
    }

    public int getNumberOfListeners() {
        return this.listeners.size();
    }

    public RecoverableZooKeeper getRecoverableZooKeeper() {
        return this.recoverableZooKeeper;
    }

    public void reconnectAfterExpiration() throws IOException, KeeperException, InterruptedException {
        this.recoverableZooKeeper.reconnectAfterExpiration();
    }

    public String getQuorum() {
        return this.quorum;
    }

    public String getBaseZNode() {
        return this.baseZNode;
    }

    public void process(WatchedEvent event) {
        LOG.debug((Object)this.prefix("Received ZooKeeper Event, type=" + event.getType() + ", " + "state=" + event.getState() + ", " + "path=" + event.getPath()));
        switch (event.getType()) {
            case None: {
                this.connectionEvent(event);
                break;
            }
            case NodeCreated: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeCreated(event.getPath());
                }
                break;
            }
            case NodeDeleted: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeDeleted(event.getPath());
                }
                break;
            }
            case NodeDataChanged: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeDataChanged(event.getPath());
                }
                break;
            }
            case NodeChildrenChanged: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeChildrenChanged(event.getPath());
                }
                break;
            }
        }
    }

    private void connectionEvent(WatchedEvent event) {
        switch (event.getState()) {
            case SyncConnected: {
                this.identifier = this.prefix + "-0x" + Long.toHexString(this.recoverableZooKeeper.getSessionId());
                LOG.debug((Object)(this.identifier + " connected"));
                break;
            }
            case Disconnected: {
                LOG.debug((Object)this.prefix("Received Disconnected from ZooKeeper, ignoring"));
                break;
            }
            case Expired: {
                String msg = this.prefix(this.identifier + " received expired from " + "ZooKeeper, aborting");
                if (this.abortable == null) break;
                this.abortable.abort(msg, (Throwable)new KeeperException.SessionExpiredException());
                break;
            }
            case ConnectedReadOnly: 
            case SaslAuthenticated: 
            case AuthFailed: {
                break;
            }
            default: {
                throw new IllegalStateException("Received event is not valid: " + event.getState());
            }
        }
    }

    public void sync(String path) throws KeeperException {
        this.recoverableZooKeeper.sync(path, null, null);
    }

    public void keeperException(KeeperException ke) throws KeeperException {
        LOG.error((Object)this.prefix("Received unexpected KeeperException, re-throwing exception"), (Throwable)ke);
        throw ke;
    }

    public void interruptedException(InterruptedException ie) {
        LOG.debug((Object)this.prefix("Received InterruptedException, doing nothing here"), (Throwable)ie);
        Thread.currentThread().interrupt();
    }

    @Override
    public void close() {
        try {
            this.recoverableZooKeeper.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void abort(String why, Throwable e) {
        if (this.abortable != null) {
            this.abortable.abort(why, e);
        } else {
            this.aborted = true;
        }
    }

    @Override
    public boolean isAborted() {
        return this.abortable == null ? this.aborted : this.abortable.isAborted();
    }

    public String getMasterAddressZNode() {
        return this.masterAddressZNode;
    }

    public String getRegionNormalizerZNode() {
        return this.regionNormalizerZNode;
    }

    public String getSwitchZNode() {
        return this.switchZNode;
    }
}

