/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.Private
public class RpcControllerFactory {
    public static final String CUSTOM_CONTROLLER_CONF_KEY = "hbase.rpc.controllerfactory.class";
    protected final Configuration conf;

    public RpcControllerFactory(Configuration conf) {
        this.conf = conf;
    }

    public PayloadCarryingRpcController newController() {
        return new PayloadCarryingRpcController();
    }

    public PayloadCarryingRpcController newController(CellScanner cellScanner) {
        return new PayloadCarryingRpcController(cellScanner);
    }

    public PayloadCarryingRpcController newController(List<CellScannable> cellIterables) {
        return new PayloadCarryingRpcController(cellIterables);
    }

    public static RpcControllerFactory instantiate(Configuration configuration) {
        String rpcControllerFactoryClazz = configuration.get(CUSTOM_CONTROLLER_CONF_KEY, RpcControllerFactory.class.getName());
        return (RpcControllerFactory)ReflectionUtils.instantiateWithCustomCtor((String)rpcControllerFactoryClazz, (Class[])new Class[]{Configuration.class}, (Object[])new Object[]{configuration});
    }
}

