/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.nodelabels.NodeLabel;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMAppsBlock;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmView;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.SchedulerPageUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfo;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

class CapacitySchedulerPage
extends RmView {
    static final String _Q = ".ui-state-default.ui-corner-all";
    static final float Q_MAX_WIDTH = 0.8f;
    static final float Q_STATS_POS = 0.85f;
    static final String Q_END = "left:101%";
    static final String Q_GIVEN = "left:0%;background:none;border:1px dashed rgba(0,0,0,0.25)";
    static final String Q_OVER = "background:rgba(255, 140, 0, 0.8)";
    static final String Q_UNDER = "background:rgba(50, 205, 50, 0.8)";

    CapacitySchedulerPage() {
    }

    protected void postHead(Hamlet.HTML<HtmlPage._> html) {
        ((Hamlet.HTML)((Hamlet.HTML)html.style().$type("text/css")._(new Object[]{"#cs { padding: 0.5em 0 1em 0; margin-bottom: 1em; position: relative }", "#cs ul { list-style: none }", "#cs a { font-weight: normal; margin: 2px; position: relative }", "#cs a span { font-weight: normal; font-size: 80% }", "#cs-wrapper .ui-widget-header { padding: 0.2em 0.5em }", ".qstats { font-weight: normal; font-size: 80%; position: absolute }", ".qlegend { font-weight: normal; padding: 0 1em; margin: 1em }", "table.info tr th {width: 50%}"})._()).script("/static/jt/jquery.jstree.js").script().$type("text/javascript")._(new Object[]{"$(function() {", "  $('#cs a span').addClass('ui-corner-all').css('position', 'absolute');", "  $('#cs').bind('loaded.jstree', function (e, data) {", "    var callback = { call:reopenQueryNodes }", "    data.inst.open_node('#pq', callback);", "   }).", "    jstree({", "    core: { animation: 188, html_titles: true },", "    plugins: ['themeroller', 'html_data', 'ui'],", "    themeroller: { item_open: 'ui-icon-minus',", "      item_clsd: 'ui-icon-plus', item_leaf: 'ui-icon-gear'", "    }", "  });", "  $('#cs').bind('select_node.jstree', function(e, data) {", "    var q = $('.q', data.rslt.obj).first().text();", "    if (q == 'Queue: root') q = '';", "    else q = '^' + q.substr(q.lastIndexOf(':') + 2) + '$';", "    $('#apps').dataTable().fnFilter(q, 4, true);", "  });", "  $('#cs').show();", "});"})._())._(SchedulerPageUtil.QueueBlockUtil.class);
    }

    @Override
    protected Class<? extends SubView> content() {
        return QueuesBlock.class;
    }

    static String percent(float f) {
        return String.format("%.1f%%", Float.valueOf(f * 100.0f));
    }

    static String width(float f) {
        return String.format("width:%.1f%%", Float.valueOf(f * 100.0f));
    }

    static String left(float f) {
        return String.format("left:%.1f%%", Float.valueOf(f * 100.0f));
    }

    static class QueuesBlock
    extends HtmlBlock {
        final CapacityScheduler cs;
        final CSQInfo csqinfo;
        private List<NodeLabel> nodeLabelsInfo;

        @Inject
        QueuesBlock(ResourceManager rm, CSQInfo info) {
            this.cs = (CapacityScheduler)rm.getResourceScheduler();
            this.csqinfo = info;
            RMNodeLabelsManager nodeLabelManager = rm.getRMContext().getNodeLabelManager();
            this.nodeLabelsInfo = nodeLabelManager.pullRMNodeLabelsInfo();
        }

        public void render(HtmlBlock.Block html) {
            html._(MetricsOverviewTable.class);
            Hamlet.UL ul = ((Hamlet.DIV)html.div("#cs-wrapper.ui-widget").div(".ui-widget-header.ui-corner-top")._(new Object[]{"Application Queues"})._()).div("#cs.ui-widget-content.ui-corner-bottom").ul();
            if (this.cs == null) {
                ((Hamlet.LI)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(CapacitySchedulerPage.Q_END)._(new Object[]{"100% "})._()).span(".q", "default")._())._();
            } else {
                ((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)ul.li().$style("margin-bottom: 1em").span().$style("font-weight: bold")._(new Object[]{"Legend:"})._()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.Q_GIVEN)._(new Object[]{"Capacity"})._()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.Q_UNDER)._(new Object[]{"Used"})._()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.Q_OVER)._(new Object[]{"Used (over capacity)"})._()).span().$class("qlegend ui-corner-all ui-state-default")._(new Object[]{"Max Capacity"})._())._();
                float used = 0.0f;
                if (null == this.nodeLabelsInfo || this.nodeLabelsInfo.size() == 1 && this.nodeLabelsInfo.get(0).getLabelName().isEmpty()) {
                    CapacitySchedulerInfo sinfo;
                    CSQueue root = this.cs.getRootQueue();
                    this.csqinfo.csinfo = sinfo = new CapacitySchedulerInfo(root, new NodeLabel(""));
                    this.csqinfo.qinfo = null;
                    used = sinfo.getUsedCapacity() / 100.0f;
                    ((Hamlet.LI)((Hamlet.LI)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(used), ";left:0%;", used > 1.0f ? CapacitySchedulerPage.Q_OVER : CapacitySchedulerPage.Q_UNDER}))._(new Object[]{"."})._()).span(".q", "Queue: root")._()).span().$class("qstats").$style(CapacitySchedulerPage.left(0.85f))._(new Object[]{StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.percent(used), " used"})})._())._(QueueBlock.class)._();
                } else {
                    for (NodeLabel label : this.nodeLabelsInfo) {
                        CapacitySchedulerInfo sinfo;
                        CSQueue root = this.cs.getRootQueue();
                        this.csqinfo.csinfo = sinfo = new CapacitySchedulerInfo(root, label);
                        this.csqinfo.qinfo = null;
                        this.csqinfo.label = label.getLabelName();
                        String nodeLabel = this.csqinfo.label.length() == 0 ? "<DEFAULT_PARTITION>" : this.csqinfo.label;
                        used = root.getUsedCapacity(label.getLabelName());
                        String partitionUiTag = "Partition: " + nodeLabel + " " + label.getResource();
                        ((Hamlet.LI)((Hamlet.LI)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(used), ";left:0%;", used > 1.0f ? CapacitySchedulerPage.Q_OVER : CapacitySchedulerPage.Q_UNDER}))._(new Object[]{"."})._()).span(".q", partitionUiTag)._()).span().$class("qstats").$style(CapacitySchedulerPage.left(0.85f))._(new Object[]{StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.percent(used), " used"})})._())._();
                        Hamlet.UL underLabel = html.ul("#pq");
                        ((Hamlet.UL)((Hamlet.LI)((Hamlet.LI)((Hamlet.A)underLabel.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(used), ";left:0%;", used > 1.0f ? CapacitySchedulerPage.Q_OVER : CapacitySchedulerPage.Q_UNDER}))._(new Object[]{"."})._()).span(".q", "Queue: root")._()).span().$class("qstats").$style(CapacitySchedulerPage.left(0.85f))._(new Object[]{StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.percent(used), " used"})})._())._(QueueBlock.class)._())._();
                    }
                }
            }
            ((Hamlet)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)ul._())._()).script().$type("text/javascript")._(new Object[]{"$('#cs').hide();"})._())._())._(RMAppsBlock.class);
        }
    }

    public static class QueueBlock
    extends HtmlBlock {
        final CSQInfo csqinfo;

        @Inject
        QueueBlock(CSQInfo info) {
            this.csqinfo = info;
        }

        public void render(HtmlBlock.Block html) {
            ArrayList<CapacitySchedulerQueueInfo> subQueues = this.csqinfo.qinfo == null ? this.csqinfo.csinfo.getQueues().getQueueInfoList() : this.csqinfo.qinfo.getQueues().getQueueInfoList();
            Hamlet.UL ul = html.ul("#pq");
            for (CapacitySchedulerQueueInfo info : subQueues) {
                float used = info.getUsedCapacity() / 100.0f;
                float absCap = info.getAbsoluteCapacity() / 100.0f;
                float absMaxCap = info.getAbsoluteMaxCapacity() / 100.0f;
                float absUsedCap = info.getAbsoluteUsedCapacity() / 100.0f;
                Hamlet.LI li = (Hamlet.LI)((Hamlet.LI)((Hamlet.A)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(absMaxCap * 0.8f)).$title(StringHelper.join((Object[])new Object[]{"Absolute Capacity:", CapacitySchedulerPage.percent(absCap)})).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.Q_GIVEN, ";font-size:1px;", CapacitySchedulerPage.width(absCap / absMaxCap)}))._(new Object[]{Character.valueOf('.')})._()).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(absUsedCap / absMaxCap), ";font-size:1px;left:0%;", absUsedCap > absCap ? CapacitySchedulerPage.Q_OVER : CapacitySchedulerPage.Q_UNDER}))._(new Object[]{Character.valueOf('.')})._()).span(".q", "Queue: " + info.getQueuePath().substring(5))._()).span().$class("qstats").$style(CapacitySchedulerPage.left(0.85f))._(new Object[]{StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.percent(used), " used"})})._();
                this.csqinfo.qinfo = info;
                if (info.getQueues() == null) {
                    ((Hamlet.UL)li.ul("#lq").li()._(LeafQueueInfoBlock.class)._())._();
                    ((Hamlet.UL)li.ul("#lq").li()._(QueueUsersInfoBlock.class)._())._();
                } else {
                    li._(QueueBlock.class);
                }
                li._();
            }
            ul._();
        }
    }

    static class QueueUsersInfoBlock
    extends HtmlBlock {
        final CapacitySchedulerLeafQueueInfo lqinfo;

        @Inject
        QueueUsersInfoBlock(View.ViewContext ctx, CSQInfo info) {
            super(ctx);
            this.lqinfo = (CapacitySchedulerLeafQueueInfo)info.qinfo;
        }

        protected void render(HtmlBlock.Block html) {
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)html.table("#userinfo").thead().$class("ui-widget-header").tr().th().$class("ui-state-default")._(new Object[]{"User Name"})._()).th().$class("ui-state-default")._(new Object[]{"Max Resource"})._()).th().$class("ui-state-default")._(new Object[]{"Used Resource"})._()).th().$class("ui-state-default")._(new Object[]{"Max AM Resource"})._()).th().$class("ui-state-default")._(new Object[]{"Used AM Resource"})._()).th().$class("ui-state-default")._(new Object[]{"Schedulable Apps"})._()).th().$class("ui-state-default")._(new Object[]{"Non-Schedulable Apps"})._())._())._()).tbody();
            ArrayList<UserInfo> users = this.lqinfo.getUsers().getUsersList();
            for (UserInfo userInfo : users) {
                tbody.tr().td(userInfo.getUsername()).td(userInfo.getUserResourceLimit().toString()).td(userInfo.getResourcesUsed().toString()).td(this.lqinfo.getUserAMResourceLimit().toString()).td(userInfo.getAMResourcesUsed().toString()).td(Integer.toString(userInfo.getNumActiveApplications())).td(Integer.toString(userInfo.getNumPendingApplications()))._();
            }
            html.div().$class("usersinfo").h5("Active Users Info")._();
            ((Hamlet.TABLE)tbody._())._();
        }
    }

    static class LeafQueueInfoBlock
    extends HtmlBlock {
        final CapacitySchedulerLeafQueueInfo lqinfo;
        private String nodeLabel;

        @Inject
        LeafQueueInfoBlock(View.ViewContext ctx, CSQInfo info) {
            super(ctx);
            this.lqinfo = (CapacitySchedulerLeafQueueInfo)info.qinfo;
            this.nodeLabel = info.label;
        }

        protected void render(HtmlBlock.Block html) {
            if (this.nodeLabel == null) {
                this.renderLeafQueueInfoWithoutParition(html);
            } else {
                this.renderLeafQueueInfoWithPartition(html);
            }
        }

        private void renderLeafQueueInfoWithPartition(HtmlBlock.Block html) {
            this.nodeLabel = this.nodeLabel.length() == 0 ? "<DEFAULT_PARTITION>" : this.nodeLabel;
            ResponseInfo ri = this.info("'" + this.lqinfo.getQueuePath().substring(5) + "' Queue Status for Partition '" + this.nodeLabel + "'");
            this.renderQueueCapacityInfo(ri);
            html._(InfoBlock.class);
            ri.clear();
            ri = this.info("'" + this.lqinfo.getQueuePath().substring(5) + "' Queue Status")._("Queue State:", (Object)this.lqinfo.getQueueState());
            this.renderCommonLeafQueueInfo(ri);
            html._(InfoBlock.class);
            ri.clear();
        }

        private void renderLeafQueueInfoWithoutParition(HtmlBlock.Block html) {
            ResponseInfo ri = this.info("'" + this.lqinfo.getQueuePath().substring(5) + "' Queue Status")._("Queue State:", (Object)this.lqinfo.getQueueState());
            this.renderQueueCapacityInfo(ri);
            this.renderCommonLeafQueueInfo(ri);
            html._(InfoBlock.class);
            ri.clear();
        }

        private void renderQueueCapacityInfo(ResponseInfo ri) {
            ri._("Used Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getUsedCapacity() / 100.0f))._("Configured Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getCapacity() / 100.0f))._("Configured Max Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getMaxCapacity() / 100.0f))._("Absolute Used Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getAbsoluteUsedCapacity() / 100.0f))._("Absolute Configured Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getAbsoluteCapacity() / 100.0f))._("Absolute Configured Max Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getAbsoluteMaxCapacity() / 100.0f))._("Used Resources:", (Object)this.lqinfo.getResourcesUsed().toString());
        }

        private void renderCommonLeafQueueInfo(ResponseInfo ri) {
            ri._("Num Schedulable Applications:", (Object)Integer.toString(this.lqinfo.getNumActiveApplications()))._("Num Non-Schedulable Applications:", (Object)Integer.toString(this.lqinfo.getNumPendingApplications()))._("Num Containers:", (Object)Integer.toString(this.lqinfo.getNumContainers()))._("Max Applications:", (Object)Integer.toString(this.lqinfo.getMaxApplications()))._("Max Applications Per User:", (Object)Integer.toString(this.lqinfo.getMaxApplicationsPerUser()))._("Max Application Master Resources:", (Object)this.lqinfo.getAMResourceLimit().toString())._("Used Application Master Resources:", (Object)this.lqinfo.getUsedAMResource().toString())._("Max Application Master Resources Per User:", (Object)this.lqinfo.getUserAMResourceLimit().toString())._("Configured Minimum User Limit Percent:", (Object)(Integer.toString(this.lqinfo.getUserLimit()) + "%"))._("Configured User Limit Factor:", (Object)StringUtils.format((String)"%.1f", (Object[])new Object[]{Float.valueOf(this.lqinfo.getUserLimitFactor())}))._("Accessible Node Labels:", (Object)StringUtils.join((CharSequence)",", this.lqinfo.getNodeLabels()))._("Preemption:", (Object)(this.lqinfo.getPreemptionDisabled() ? "disabled" : "enabled"));
        }
    }

    @RequestScoped
    static class CSQInfo {
        CapacitySchedulerInfo csinfo;
        CapacitySchedulerQueueInfo qinfo;
        String label;

        CSQInfo() {
        }
    }
}

