/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;

public abstract class AbstractCSQueue
implements CSQueue {
    CSQueue parent;
    final String queueName;
    volatile int numContainers;
    Resource minimumAllocation;
    Resource maximumAllocation;
    QueueState state;
    final QueueMetrics metrics;
    final ResourceCalculator resourceCalculator;
    Set<String> accessibleLabels;
    RMNodeLabelsManager labelManager;
    String defaultLabelExpression;
    Map<QueueACL, AccessControlList> acls = new HashMap<QueueACL, AccessControlList>();
    boolean reservationsContinueLooking;
    ResourceUsage queueUsage;
    QueueCapacities queueCapacities;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected CapacitySchedulerContext csContext;

    public AbstractCSQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) throws IOException {
        this.labelManager = cs.getRMContext().getNodeLabelManager();
        this.parent = parent;
        this.queueName = queueName;
        this.resourceCalculator = cs.getResourceCalculator();
        this.metrics = old != null ? old.getMetrics() : QueueMetrics.forQueue(this.getQueuePath(), parent, cs.getConfiguration().getEnableUserMetrics(), cs.getConf());
        this.csContext = cs;
        this.queueUsage = new ResourceUsage();
        this.queueCapacities = new QueueCapacities(parent == null);
    }

    protected void setupConfigurableCapacities() {
        CSQueueUtils.loadUpdateAndCheckCapacities(this.getQueuePath(), this.csContext.getConfiguration(), this.queueCapacities, this.parent == null ? null : this.parent.getQueueCapacities());
    }

    @Override
    public synchronized float getCapacity() {
        return this.queueCapacities.getCapacity();
    }

    @Override
    public synchronized float getAbsoluteCapacity() {
        return this.queueCapacities.getAbsoluteCapacity();
    }

    @Override
    public float getAbsoluteMaximumCapacity() {
        return this.queueCapacities.getAbsoluteMaximumCapacity();
    }

    @Override
    public synchronized float getAbsoluteUsedCapacity() {
        return this.queueCapacities.getAbsoluteUsedCapacity();
    }

    @Override
    public float getMaximumCapacity() {
        return this.queueCapacities.getMaximumCapacity();
    }

    @Override
    public synchronized float getUsedCapacity() {
        return this.queueCapacities.getUsedCapacity();
    }

    @Override
    public Resource getUsedResources() {
        return this.queueUsage.getUsed();
    }

    public synchronized int getNumContainers() {
        return this.numContainers;
    }

    @Override
    public synchronized QueueState getState() {
        return this.state;
    }

    @Override
    public QueueMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public synchronized CSQueue getParent() {
        return this.parent;
    }

    @Override
    public synchronized void setParent(CSQueue newParentQueue) {
        this.parent = (ParentQueue)newParentQueue;
    }

    @Override
    public Set<String> getAccessibleNodeLabels() {
        return this.accessibleLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
        AbstractCSQueue abstractCSQueue = this;
        synchronized (abstractCSQueue) {
            if (this.acls.get(acl).isUserAllowed(user)) {
                return true;
            }
        }
        if (this.parent != null) {
            return this.parent.hasAccess(acl, user);
        }
        return false;
    }

    @Override
    public synchronized void setUsedCapacity(float usedCapacity) {
        this.queueCapacities.setUsedCapacity(usedCapacity);
    }

    @Override
    public synchronized void setAbsoluteUsedCapacity(float absUsedCapacity) {
        this.queueCapacities.setAbsoluteUsedCapacity(absUsedCapacity);
    }

    synchronized void setMaxCapacity(float maximumCapacity) {
        CSQueueUtils.checkMaxCapacity(this.getQueueName(), this.queueCapacities.getCapacity(), maximumCapacity);
        float absMaxCapacity = CSQueueUtils.computeAbsoluteMaximumCapacity(maximumCapacity, this.parent);
        CSQueueUtils.checkAbsoluteCapacity(this.getQueueName(), this.queueCapacities.getAbsoluteCapacity(), absMaxCapacity);
        this.queueCapacities.setMaximumCapacity(maximumCapacity);
        this.queueCapacities.setAbsoluteMaximumCapacity(absMaxCapacity);
    }

    @Override
    public String getDefaultNodeLabelExpression() {
        return this.defaultLabelExpression;
    }

    synchronized void setupQueueConfigs(Resource clusterResource) throws IOException {
        this.accessibleLabels = this.csContext.getConfiguration().getAccessibleNodeLabels(this.getQueuePath());
        this.defaultLabelExpression = this.csContext.getConfiguration().getDefaultNodeLabelExpression(this.getQueuePath());
        if (this.accessibleLabels == null && this.parent != null) {
            this.accessibleLabels = this.parent.getAccessibleNodeLabels();
        }
        if (this.defaultLabelExpression == null && this.parent != null && this.accessibleLabels.containsAll(this.parent.getAccessibleNodeLabels())) {
            this.defaultLabelExpression = this.parent.getDefaultNodeLabelExpression();
        }
        this.setupConfigurableCapacities();
        this.minimumAllocation = this.csContext.getMinimumResourceCapability();
        this.maximumAllocation = this.csContext.getMaximumResourceCapability();
        this.state = this.csContext.getConfiguration().getState(this.getQueuePath());
        this.acls = this.csContext.getConfiguration().getAcls(this.getQueuePath());
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.parent, clusterResource, this.minimumAllocation);
        if (this.parent != null && this.parent.getParent() != null && this.parent.getAccessibleNodeLabels() != null && !this.parent.getAccessibleNodeLabels().contains("*")) {
            if (this.getAccessibleNodeLabels().contains("*")) {
                throw new IOException("Parent's accessible queue is not ANY(*), but child's accessible queue is *");
            }
            Sets.SetView diff = Sets.difference(this.getAccessibleNodeLabels(), this.parent.getAccessibleNodeLabels());
            if (!diff.isEmpty()) {
                throw new IOException("Some labels of child queue is not a subset of parent queue, these labels=[" + StringUtils.join((Collection)diff, (String)",") + "]");
            }
        }
        this.reservationsContinueLooking = this.csContext.getConfiguration().getReservationContinueLook();
    }

    protected QueueInfo getQueueInfo() {
        QueueInfo queueInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        queueInfo.setQueueName(this.queueName);
        queueInfo.setAccessibleNodeLabels(this.accessibleLabels);
        queueInfo.setCapacity(this.queueCapacities.getCapacity());
        queueInfo.setMaximumCapacity(this.queueCapacities.getMaximumCapacity());
        queueInfo.setQueueState(this.state);
        queueInfo.setDefaultNodeLabelExpression(this.defaultLabelExpression);
        queueInfo.setCurrentCapacity(this.getUsedCapacity());
        return queueInfo;
    }

    @InterfaceAudience.Private
    public Resource getMaximumAllocation() {
        return this.maximumAllocation;
    }

    @InterfaceAudience.Private
    public Resource getMinimumAllocation() {
        return this.minimumAllocation;
    }

    synchronized void allocateResource(Resource clusterResource, Resource resource, Set<String> nodeLabels) {
        if (nodeLabels == null || nodeLabels.isEmpty()) {
            this.queueUsage.incUsed(resource);
        } else {
            for (String label : Sets.intersection(this.accessibleLabels, nodeLabels)) {
                this.queueUsage.incUsed(label, resource);
            }
        }
        ++this.numContainers;
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.getParent(), clusterResource, this.minimumAllocation);
    }

    protected synchronized void releaseResource(Resource clusterResource, Resource resource, Set<String> nodeLabels) {
        if (null == nodeLabels || nodeLabels.isEmpty()) {
            this.queueUsage.decUsed(resource);
        } else {
            for (String label : Sets.intersection(this.accessibleLabels, nodeLabels)) {
                this.queueUsage.decUsed(label, resource);
            }
        }
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.getParent(), clusterResource, this.minimumAllocation);
        --this.numContainers;
    }

    @InterfaceAudience.Private
    public boolean getReservationContinueLooking() {
        return this.reservationsContinueLooking;
    }

    @InterfaceAudience.Private
    public Map<QueueACL, AccessControlList> getACLs() {
        return this.acls;
    }

    @Override
    @InterfaceAudience.Private
    public QueueCapacities getQueueCapacities() {
        return this.queueCapacities;
    }

    @Override
    @InterfaceAudience.Private
    public ResourceUsage getQueueResourceUsage() {
        return this.queueUsage;
    }
}

