/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class VIntWritable
implements WritableComparable<VIntWritable> {
    private int value;

    public VIntWritable() {
    }

    public VIntWritable(int value) {
        this.set(value);
    }

    public void set(int value) {
        this.value = value;
    }

    public int get() {
        return this.value;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = WritableUtils.readVInt(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof VIntWritable)) {
            return false;
        }
        VIntWritable other = (VIntWritable)o;
        return this.value == other.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(VIntWritable o) {
        int thisValue = this.value;
        int thatValue = o.value;
        return thisValue < thatValue ? -1 : (thisValue == thatValue ? 0 : 1);
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

