/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.apache.flink.table.data.RowData;

class TopNBuffer
implements Serializable {
    private static final long serialVersionUID = 6824488508991990228L;
    private final Supplier<Collection<RowData>> valueSupplier;
    private final Comparator<RowData> sortKeyComparator;
    private int currentTopNum = 0;
    private TreeMap<RowData, Collection<RowData>> treeMap;

    TopNBuffer(Comparator<RowData> sortKeyComparator, Supplier<Collection<RowData>> valueSupplier) {
        this.valueSupplier = valueSupplier;
        this.sortKeyComparator = sortKeyComparator;
        this.treeMap = new TreeMap(sortKeyComparator);
    }

    public int put(RowData sortKey, RowData value) {
        ++this.currentTopNum;
        Collection<RowData> collection = this.treeMap.get(sortKey);
        if (collection == null) {
            collection = this.valueSupplier.get();
            this.treeMap.put(sortKey, collection);
        }
        collection.add(value);
        return collection.size();
    }

    void putAll(RowData sortKey, Collection<RowData> values) {
        Collection<RowData> oldValues = this.treeMap.get(sortKey);
        if (oldValues != null) {
            this.currentTopNum -= oldValues.size();
        }
        this.treeMap.put(sortKey, values);
        this.currentTopNum += values.size();
    }

    public Collection<RowData> get(RowData sortKey) {
        return this.treeMap.get(sortKey);
    }

    public void remove(RowData sortKey, RowData value) {
        Collection<RowData> collection = this.treeMap.get(sortKey);
        if (collection != null) {
            if (collection.remove(value)) {
                --this.currentTopNum;
            }
            if (collection.size() == 0) {
                this.treeMap.remove(sortKey);
            }
        }
    }

    void removeAll(RowData sortKey) {
        Collection<RowData> collection = this.treeMap.get(sortKey);
        if (collection != null) {
            this.currentTopNum -= collection.size();
            this.treeMap.remove(sortKey);
        }
    }

    RowData removeLast() {
        Collection<RowData> collection;
        Map.Entry<RowData, Collection<RowData>> last = this.treeMap.lastEntry();
        RowData lastElement = null;
        if (last != null && (collection = last.getValue()) != null) {
            if (collection instanceof List) {
                List list = (List)collection;
                if (!list.isEmpty()) {
                    lastElement = (RowData)list.remove(list.size() - 1);
                    --this.currentTopNum;
                    if (list.isEmpty()) {
                        this.treeMap.remove(last.getKey());
                    }
                }
            } else {
                lastElement = this.getLastElement(collection);
                if (lastElement != null) {
                    if (collection.remove(lastElement)) {
                        --this.currentTopNum;
                    }
                    if (collection.size() == 0) {
                        this.treeMap.remove(last.getKey());
                    }
                }
            }
        }
        return lastElement;
    }

    RowData lastElement() {
        Map.Entry<RowData, Collection<RowData>> last = this.treeMap.lastEntry();
        RowData lastElement = null;
        if (last != null) {
            Collection<RowData> collection = last.getValue();
            lastElement = this.getLastElement(collection);
        }
        return lastElement;
    }

    RowData getElement(int rank) {
        int curRank = 0;
        for (Map.Entry<RowData, Collection<RowData>> entry : this.treeMap.entrySet()) {
            Collection<RowData> collection = entry.getValue();
            if (curRank + collection.size() >= rank) {
                for (RowData elem : collection) {
                    if (++curRank != rank) continue;
                    return elem;
                }
                continue;
            }
            curRank += collection.size();
        }
        return null;
    }

    private RowData getLastElement(Collection<RowData> collection) {
        RowData element = null;
        if (collection != null && !collection.isEmpty()) {
            if (collection instanceof List) {
                List list = (List)collection;
                return (RowData)list.get(list.size() - 1);
            }
            Iterator<RowData> iterator = collection.iterator();
            while (iterator.hasNext()) {
                RowData data;
                element = data = iterator.next();
            }
        }
        return element;
    }

    Set<Map.Entry<RowData, Collection<RowData>>> entrySet() {
        return this.treeMap.entrySet();
    }

    Map.Entry<RowData, Collection<RowData>> lastEntry() {
        return this.treeMap.lastEntry();
    }

    boolean containsKey(RowData key) {
        return this.treeMap.containsKey(key);
    }

    int getCurrentTopNum() {
        return this.currentTopNum;
    }

    Comparator<RowData> getSortKeyComparator() {
        return this.sortKeyComparator;
    }
}

