/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.conversion;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.runtime.generated.CompileUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@Internal
public class StructuredObjectConverter<T>
implements DataStructureConverter<RowData, T> {
    private static final long serialVersionUID = 1L;
    private final DataStructureConverter<Object, Object>[] fieldConverters;
    private final RowData.FieldGetter[] fieldGetters;
    private final String generatedName;
    private final String generatedCode;
    private transient DataStructureConverter<RowData, T> generatedConverter;

    private StructuredObjectConverter(DataStructureConverter<Object, Object>[] fieldConverters, RowData.FieldGetter[] fieldGetters, String generatedName, String generatedCode) {
        this.fieldConverters = fieldConverters;
        this.fieldGetters = fieldGetters;
        this.generatedName = generatedName;
        this.generatedCode = generatedCode;
    }

    @Override
    public void open(ClassLoader classLoader) {
        for (DataStructureConverter<Object, Object> fieldConverter : this.fieldConverters) {
            fieldConverter.open(classLoader);
        }
        try {
            Class compiledConverter = CompileUtils.compile(classLoader, this.generatedName, this.generatedCode);
            this.generatedConverter = (DataStructureConverter)compiledConverter.getConstructor(RowData.FieldGetter[].class, DataStructureConverter[].class).newInstance(this.fieldGetters, this.fieldConverters);
        }
        catch (Throwable t) {
            throw new TableException("Error while generating structured type converter.", t);
        }
        this.generatedConverter.open(classLoader);
    }

    @Override
    public RowData toInternal(T external) {
        return this.generatedConverter.toInternal(external);
    }

    @Override
    public T toExternal(RowData internal) {
        return this.generatedConverter.toExternal(internal);
    }

    public static StructuredObjectConverter<?> create(DataType dataType) {
        try {
            return StructuredObjectConverter.createOrError(dataType);
        }
        catch (Throwable t) {
            throw new TableException(String.format("Could not create converter for structured type '%s'.", dataType), t);
        }
    }

    private static StructuredObjectConverter<?> createOrError(DataType dataType) {
        List fields = dataType.getChildren();
        DataStructureConverter[] fieldConverters = (DataStructureConverter[])fields.stream().map(dt -> DataStructureConverters.getConverter(dt)).toArray(DataStructureConverter[]::new);
        RowData.FieldGetter[] fieldGetters = (RowData.FieldGetter[])IntStream.range(0, fields.size()).mapToObj(pos -> RowData.createFieldGetter((LogicalType)((DataType)fields.get(pos)).getLogicalType(), (int)pos)).toArray(RowData.FieldGetter[]::new);
        Class[] fieldClasses = (Class[])fields.stream().map(DataType::getConversionClass).toArray(Class[]::new);
        StructuredType structuredType = (StructuredType)dataType.getLogicalType();
        Class implementationClass = (Class)structuredType.getImplementationClass().orElseThrow(IllegalStateException::new);
        String converterName = implementationClass.getName().replace('.', '$') + "$Converter";
        String converterCode = StructuredObjectConverter.generateCode(converterName, implementationClass, LogicalTypeChecks.getFieldNames((LogicalType)structuredType).toArray(new String[0]), fieldClasses);
        return new StructuredObjectConverter(fieldConverters, fieldGetters, converterName, converterCode);
    }

    private static String generateCode(String converterName, Class<?> clazz, String[] fieldNames, Class<?>[] fieldClasses) {
        int pos;
        int fieldCount = fieldClasses.length;
        StringBuilder sb = new StringBuilder();
        StructuredObjectConverter.line(sb, "public class ", converterName, " implements ", DataStructureConverter.class, " {");
        StructuredObjectConverter.line(sb, "    private final ", RowData.FieldGetter.class, "[] fieldGetters;");
        StructuredObjectConverter.line(sb, "    private final ", DataStructureConverter.class, "[] fieldConverters;");
        StructuredObjectConverter.line(sb, "    public ", converterName, "(", RowData.FieldGetter.class, "[] fieldGetters, ", DataStructureConverter.class, "[] fieldConverters) {");
        StructuredObjectConverter.line(sb, "        this.fieldGetters = fieldGetters;");
        StructuredObjectConverter.line(sb, "        this.fieldConverters = fieldConverters;");
        StructuredObjectConverter.line(sb, "    }");
        StructuredObjectConverter.line(sb, "    public ", Object.class, " toInternal(", Object.class, " o) {");
        StructuredObjectConverter.line(sb, "        final ", clazz, " external = (", clazz, ") o;");
        StructuredObjectConverter.line(sb, "        final ", GenericRowData.class, " genericRow = new ", GenericRowData.class, "(", fieldCount, ");");
        for (pos = 0; pos < fieldCount; ++pos) {
            StructuredObjectConverter.line(sb, "        ", StructuredObjectConverter.getterExpr(clazz, pos, fieldNames[pos], fieldClasses[pos]), ";");
        }
        StructuredObjectConverter.line(sb, "        return genericRow;");
        StructuredObjectConverter.line(sb, "    }");
        StructuredObjectConverter.line(sb, "    public ", Object.class, " toExternal(", Object.class, " o) {");
        StructuredObjectConverter.line(sb, "        final ", RowData.class, " internal = (", RowData.class, ") o;");
        if (ExtractionUtils.hasInvokableConstructor(clazz, (Class[])fieldClasses)) {
            StructuredObjectConverter.line(sb, "        final ", clazz, " structured = new ", clazz, "(");
            for (pos = 0; pos < fieldCount; ++pos) {
                StructuredObjectConverter.line(sb, "            ", StructuredObjectConverter.parameterExpr(pos, fieldClasses[pos]), pos < fieldCount - 1 ? ", " : "");
            }
            StructuredObjectConverter.line(sb, "        );");
        } else {
            StructuredObjectConverter.line(sb, "        final ", clazz, " structured = new ", clazz, "();");
            for (pos = 0; pos < fieldCount; ++pos) {
                StructuredObjectConverter.line(sb, "        ", StructuredObjectConverter.setterExpr(clazz, pos, fieldNames[pos]), ";");
            }
        }
        StructuredObjectConverter.line(sb, "        return structured;");
        StructuredObjectConverter.line(sb, "    }");
        StructuredObjectConverter.line(sb, "}");
        return sb.toString();
    }

    private static String getterExpr(Class<?> implementationClass, int pos, String fieldName, Class<?> fieldClass) {
        String accessExpr;
        Field field = ExtractionUtils.getStructuredField(implementationClass, (String)fieldName);
        if (ExtractionUtils.isStructuredFieldDirectlyReadable((Field)field)) {
            accessExpr = StructuredObjectConverter.expr("external.", field.getName());
        } else {
            Method getter = (Method)ExtractionUtils.getStructuredFieldGetter(implementationClass, (Field)field).orElseThrow(IllegalStateException::new);
            accessExpr = StructuredObjectConverter.expr("external.", getter.getName(), "()");
        }
        accessExpr = StructuredObjectConverter.castExpr(accessExpr, fieldClass);
        return StructuredObjectConverter.expr("genericRow.setField(", pos, ", fieldConverters[", pos, "].toInternalOrNull(", accessExpr, "))");
    }

    private static String parameterExpr(int pos, Class<?> fieldClass) {
        String conversionExpr = StructuredObjectConverter.expr("fieldConverters[", pos, "].toExternalOrNull(fieldGetters[", pos, "].getFieldOrNull(internal))");
        return StructuredObjectConverter.castExpr(conversionExpr, fieldClass);
    }

    private static String setterExpr(Class<?> implementationClass, int pos, String fieldName) {
        Field field = ExtractionUtils.getStructuredField(implementationClass, (String)fieldName);
        String conversionExpr = StructuredObjectConverter.expr("fieldConverters[", pos, "].toExternalOrNull(fieldGetters[", pos, "].getFieldOrNull(internal))");
        if (ExtractionUtils.isStructuredFieldDirectlyWritable((Field)field)) {
            return StructuredObjectConverter.expr("structured.", field.getName(), " = ", StructuredObjectConverter.castExpr(conversionExpr, field.getType()));
        }
        Method setter = (Method)ExtractionUtils.getStructuredFieldSetter(implementationClass, (Field)field).orElseThrow(IllegalStateException::new);
        return StructuredObjectConverter.expr("structured.", setter.getName(), "(", StructuredObjectConverter.castExpr(conversionExpr, setter.getParameterTypes()[0]), ")");
    }

    private static String castExpr(String expr, Class<?> clazz) {
        return StructuredObjectConverter.expr("((", ExtractionUtils.primitiveToWrapper(clazz), ") ", expr, ")");
    }

    private static String expr(Object ... parts) {
        StringBuilder sb = new StringBuilder();
        for (Object part : parts) {
            if (part instanceof Class) {
                sb.append(((Class)part).getCanonicalName());
                continue;
            }
            sb.append(part);
        }
        return sb.toString();
    }

    private static void line(StringBuilder sb, Object ... parts) {
        for (Object part : parts) {
            if (part instanceof Class) {
                sb.append(((Class)part).getCanonicalName());
                continue;
            }
            sb.append(part);
        }
        sb.append("\n");
    }
}

