/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecLegacySink;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;

public class StreamExecLegacySink<T>
extends CommonExecLegacySink<T>
implements StreamExecNode<T> {
    public StreamExecLegacySink(TableSink<T> tableSink, @Nullable String[] upsertKeys, boolean needRetraction, InputProperty inputProperty, LogicalType outputType, String description) {
        super(tableSink, upsertKeys, needRetraction, true, inputProperty, outputType, description);
    }

    @Override
    protected RowType checkAndConvertInputTypeIfNeeded(RowType inputRowType) {
        ArrayList<Integer> rowtimeFieldIndices = new ArrayList<Integer>();
        for (int i2 = 0; i2 < inputRowType.getFieldCount(); ++i2) {
            if (!TypeCheckUtils.isRowTime((LogicalType)inputRowType.getTypeAt(i2))) continue;
            rowtimeFieldIndices.add(i2);
        }
        if (rowtimeFieldIndices.size() > 1) {
            throw new TableException(String.format("Found more than one rowtime field: [%s] in the table that should be converted to a DataStream.\nPlease select the rowtime field that should be used as event-time timestamp for the DataStream by casting all other fields to TIMESTAMP.", rowtimeFieldIndices.stream().map(i -> (String)inputRowType.getFieldNames().get((int)i)).collect(Collectors.joining(", "))));
        }
        if (rowtimeFieldIndices.size() == 1) {
            LogicalType[] convertedFieldTypes = (LogicalType[])inputRowType.getChildren().stream().map(t -> {
                if (TypeCheckUtils.isRowTime((LogicalType)t)) {
                    if (TypeCheckUtils.isTimestampWithLocalZone((LogicalType)t)) {
                        return new LocalZonedTimestampType(3);
                    }
                    return new TimestampType(3);
                }
                return t;
            }).toArray(LogicalType[]::new);
            return RowType.of((LogicalType[])convertedFieldTypes, (String[])inputRowType.getFieldNames().toArray(new String[0]));
        }
        return inputRowType;
    }
}

