/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;

public abstract class SumAggFunction
extends DeclarativeAggregateFunction {
    protected UnresolvedReferenceExpression sum = ApiExpressionUtils.unresolvedRef((String)"sum");

    @Override
    public int operandCount() {
        return 1;
    }

    @Override
    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        return new UnresolvedReferenceExpression[]{this.sum};
    }

    @Override
    public DataType[] getAggBufferTypes() {
        return new DataType[]{this.getResultType()};
    }

    @Override
    public Expression[] initialValuesExpressions() {
        return new Expression[]{ExpressionBuilder.nullOf(this.getResultType())};
    }

    @Override
    public Expression[] accumulateExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.sum, (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.sum, (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.sum), (Expression)this.operand(0), (Expression)this.doPlus(this.sum, this.operand(0)))))};
    }

    @Override
    public Expression[] retractExpressions() {
        throw new TableException("This function does not support retraction, Please choose SumWithRetractAggFunction.");
    }

    @Override
    public Expression[] mergeExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.mergeOperand(this.sum)), (Expression)this.sum, (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.sum), (Expression)this.mergeOperand(this.sum), (Expression)this.doPlus(this.sum, this.mergeOperand(this.sum))))};
    }

    protected UnresolvedCallExpression doPlus(UnresolvedReferenceExpression arg1, UnresolvedReferenceExpression arg2) {
        return ExpressionBuilder.plus((Expression)arg1, (Expression)arg2);
    }

    @Override
    public Expression getValueExpression() {
        return this.sum;
    }

    public static class DecimalSumAggFunction
    extends SumAggFunction {
        private DecimalType decimalType;
        private DataType returnType;

        public DecimalSumAggFunction(DecimalType decimalType) {
            this.decimalType = decimalType;
        }

        @Override
        public DataType getResultType() {
            if (this.returnType == null) {
                DecimalType sumType = (DecimalType)LogicalTypeMerging.findSumAggType((LogicalType)this.decimalType);
                this.returnType = DataTypes.DECIMAL((int)sumType.getPrecision(), (int)sumType.getScale());
            }
            return this.returnType;
        }

        @Override
        protected UnresolvedCallExpression doPlus(UnresolvedReferenceExpression arg1, UnresolvedReferenceExpression arg2) {
            return ExpressionBuilder.aggDecimalPlus((Expression)arg1, (Expression)arg2);
        }
    }

    public static class DoubleSumAggFunction
    extends SumAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.DOUBLE();
        }
    }

    public static class FloatSumAggFunction
    extends SumAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.FLOAT();
        }
    }

    public static class LongSumAggFunction
    extends SumAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.BIGINT();
        }
    }

    public static class ShortSumAggFunction
    extends SumAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.SMALLINT();
        }
    }

    public static class ByteSumAggFunction
    extends SumAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.TINYINT();
        }
    }

    public static class IntSumAggFunction
    extends SumAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.INT();
        }
    }
}

