/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter.converters;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlJsonEmptyOrError;
import org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import org.apache.flink.table.api.JsonValueOnEmptyOrError;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.expressions.converter.converters.CustomizedConverter;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.utils.ShortcutUtils;

class JsonValueConverter
extends CustomizedConverter {
    JsonValueConverter() {
    }

    @Override
    public RexNode convert(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        JsonValueConverter.checkArgumentNumber(call, 7);
        LinkedList<RexNode> operands = new LinkedList<RexNode>();
        operands.add(context.toRexNode((Expression)call.getChildren().get(0)));
        operands.add(context.toRexNode((Expression)call.getChildren().get(1)));
        operands.addAll(this.getBehaviorOperands(call, context, SqlJsonEmptyOrError.EMPTY));
        operands.addAll(this.getBehaviorOperands(call, context, SqlJsonEmptyOrError.ERROR));
        FlinkTypeFactory typeFactory = ShortcutUtils.unwrapTypeFactory(context.getRelBuilder());
        RelDataType returnRelType = typeFactory.createFieldTypeFromLogicalType(call.getOutputDataType().getLogicalType());
        return context.getRelBuilder().getRexBuilder().makeCall(returnRelType, FlinkSqlOperatorTable.JSON_VALUE, operands);
    }

    private List<RexNode> getBehaviorOperands(CallExpression call, CallExpressionConvertRule.ConvertContext context, SqlJsonEmptyOrError mode) {
        int idx = this.getArgumentIndexForBehavior(mode);
        SqlJsonValueEmptyOrErrorBehavior behavior = this.getBehavior(call, idx);
        Expression defaultExpression = (Expression)call.getChildren().get(idx + 1);
        ArrayList<RexNode> operands = new ArrayList<RexNode>();
        operands.add(context.getRelBuilder().getRexBuilder().makeFlag(behavior));
        if (behavior == SqlJsonValueEmptyOrErrorBehavior.DEFAULT) {
            operands.add(context.toRexNode(defaultExpression));
        }
        operands.add(context.getRelBuilder().getRexBuilder().makeFlag(mode));
        return operands;
    }

    private SqlJsonValueEmptyOrErrorBehavior getBehavior(CallExpression call, int idx) {
        return ((ValueLiteralExpression)call.getChildren().get(idx)).getValueAs(JsonValueOnEmptyOrError.class).map(Enum::name).map(SqlJsonValueEmptyOrErrorBehavior::valueOf).orElseThrow(() -> new TableException(String.format("Did not find a '%s' at position %d. This is a bug. Please consider filing an issue.", JsonValueOnEmptyOrError.class.getSimpleName(), idx)));
    }

    private int getArgumentIndexForBehavior(SqlJsonEmptyOrError mode) {
        switch (mode) {
            case EMPTY: {
                return 3;
            }
            case ERROR: {
                return 5;
            }
        }
        throw new TableException(String.format("Unexpected behavior mode '%s'. This is a bug. Please consider filing an issue.", mode));
    }
}

