/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.TypeLiteralExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;

public class ExpressionBuilder {
    public static ValueLiteralExpression nullOf(DataType type) {
        return ExpressionBuilder.literal(null, type);
    }

    public static ValueLiteralExpression literal(Object value) {
        return ApiExpressionUtils.valueLiteral((Object)value);
    }

    public static ValueLiteralExpression literal(Object value, DataType type) {
        if (value != null) {
            return ApiExpressionUtils.valueLiteral((Object)value, (DataType)((DataType)type.notNull()));
        }
        return ApiExpressionUtils.valueLiteral(null, (DataType)((DataType)type.nullable()));
    }

    public static UnresolvedCallExpression call(FunctionDefinition functionDefinition, Expression ... args) {
        return ApiExpressionUtils.unresolvedCall((FunctionDefinition)functionDefinition, (Expression[])args);
    }

    public static UnresolvedCallExpression call(FunctionDefinition functionDefinition, List<Expression> args) {
        return ApiExpressionUtils.unresolvedCall((FunctionDefinition)functionDefinition, (Expression[])args.toArray(new Expression[0]));
    }

    public static UnresolvedCallExpression and(Expression arg1, Expression arg2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.AND, arg1, arg2);
    }

    public static UnresolvedCallExpression or(Expression arg1, Expression arg2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.OR, arg1, arg2);
    }

    public static UnresolvedCallExpression not(Expression arg) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.NOT, arg);
    }

    public static UnresolvedCallExpression isNull(Expression input) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.IS_NULL, input);
    }

    public static UnresolvedCallExpression ifThenElse(Expression condition, Expression ifTrue, Expression ifFalse) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.IF, condition, ifTrue, ifFalse);
    }

    public static UnresolvedCallExpression plus(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.PLUS, input1, input2);
    }

    @Internal
    public static UnresolvedCallExpression aggDecimalPlus(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.AGG_DECIMAL_PLUS, input1, input2);
    }

    public static UnresolvedCallExpression minus(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.MINUS, input1, input2);
    }

    public static UnresolvedCallExpression div(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.DIVIDE, input1, input2);
    }

    public static UnresolvedCallExpression times(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.TIMES, input1, input2);
    }

    public static UnresolvedCallExpression mod(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.MOD, input1, input2);
    }

    public static UnresolvedCallExpression equalTo(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, input1, input2);
    }

    public static UnresolvedCallExpression lessThan(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN, input1, input2);
    }

    public static UnresolvedCallExpression greaterThan(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, input1, input2);
    }

    public static UnresolvedCallExpression cast(Expression child, Expression type) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.CAST, child, type);
    }

    public static UnresolvedCallExpression reinterpretCast(Expression child, Expression type, boolean checkOverflow) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.REINTERPRET_CAST, new Expression[]{child, type, ExpressionBuilder.literal(checkOverflow)});
    }

    public static TypeLiteralExpression typeLiteral(DataType type) {
        return ApiExpressionUtils.typeLiteral((DataType)type);
    }

    public static UnresolvedCallExpression concat(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.CONCAT, input1, input2);
    }
}

