/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlInternalOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;

class SqlRollupOperator
extends SqlInternalOperator {
    SqlRollupOperator(String name, SqlKind kind) {
        super(name, kind, 4);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (this.kind) {
            case ROLLUP: {
                if (writer.getDialect().supportsAggregateFunction(this.kind) || !writer.getDialect().supportsGroupByWithRollup()) break;
                this.unparseKeyword(writer, call, "WITH ROLLUP");
                return;
            }
            case CUBE: {
                if (writer.getDialect().supportsAggregateFunction(this.kind) || !writer.getDialect().supportsGroupByWithCube()) break;
                this.unparseKeyword(writer, call, "WITH CUBE");
                return;
            }
        }
        this.unparseCube(writer, call);
    }

    private void unparseKeyword(SqlWriter writer, SqlCall call, String keyword) {
        SqlWriter.Frame groupFrame = writer.startList(SqlWriter.FrameTypeEnum.GROUP_BY_LIST);
        for (SqlNode operand : call.getOperandList()) {
            writer.sep(",");
            operand.unparse(writer, 2, 3);
        }
        writer.endList(groupFrame);
        writer.keyword(keyword);
    }

    private void unparseCube(SqlWriter writer, SqlCall call) {
        writer.keyword(call.getOperator().getName());
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
        for (SqlNode operand : call.getOperandList()) {
            writer.sep(",");
            if (operand.getKind() == SqlKind.ROW) {
                SqlWriter.Frame frame2 = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE, "(", ")");
                for (SqlNode operand2 : ((SqlCall)operand).getOperandList()) {
                    writer.sep(",");
                    operand2.unparse(writer, 0, 0);
                }
                writer.endList(frame2);
                continue;
            }
            if (operand instanceof SqlNodeList && ((SqlNodeList)operand).size() == 0) {
                writer.keyword("()");
                continue;
            }
            operand.unparse(writer, 0, 0);
        }
        writer.endList(frame);
    }
}

