/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.interpreter.Context;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.calcite.linq4j.tree.MemberExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IClassBodyEvaluator;
import org.codehaus.commons.compiler.ICompilerFactory;

public class JaninoRexCompiler
implements Interpreter.ScalarCompiler {
    private final RexBuilder rexBuilder;

    public JaninoRexCompiler(RexBuilder rexBuilder) {
        this.rexBuilder = rexBuilder;
    }

    @Override
    public Scalar compile(List<RexNode> nodes, RelDataType inputRowType) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, this.rexBuilder);
        for (RexNode node : nodes) {
            programBuilder.addProject(node, null);
        }
        RexProgram program = programBuilder.getProgram();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression context_ = Expressions.parameter(Context.class, "context");
        ParameterExpression outputValues_ = Expressions.parameter(Object[].class, "outputValues");
        JavaTypeFactoryImpl javaTypeFactory = new JavaTypeFactoryImpl(this.rexBuilder.getTypeFactory().getTypeSystem());
        RexToLixTranslator.InputGetterImpl inputGetter = new RexToLixTranslator.InputGetterImpl(ImmutableList.of(Pair.of(Expressions.field((Expression)context_, BuiltInMethod.CONTEXT_VALUES.field), PhysTypeImpl.of(javaTypeFactory, inputRowType, JavaRowFormat.ARRAY, false))));
        Function1<String, RexToLixTranslator.InputGetter> correlates = a0 -> {
            throw new UnsupportedOperationException();
        };
        MemberExpression root = Expressions.field((Expression)context_, BuiltInMethod.CONTEXT_ROOT.field);
        SqlConformanceEnum conformance = SqlConformanceEnum.DEFAULT;
        List<Expression> list = RexToLixTranslator.translateProjects(program, javaTypeFactory, conformance, builder, null, root, inputGetter, correlates);
        for (int i = 0; i < list.size(); ++i) {
            builder.add(Expressions.statement(Expressions.assign(Expressions.arrayIndex(outputValues_, Expressions.constant(i)), list.get(i))));
        }
        return JaninoRexCompiler.baz(context_, outputValues_, builder.toBlock());
    }

    static Scalar baz(ParameterExpression context_, ParameterExpression outputValues_, BlockStatement block) {
        ArrayList<MemberDeclaration> declarations = new ArrayList<MemberDeclaration>();
        declarations.add(Expressions.methodDecl(1, Void.TYPE, BuiltInMethod.SCALAR_EXECUTE2.method.getName(), ImmutableList.of(context_, outputValues_), block));
        BlockBuilder builder = new BlockBuilder();
        Expression values_ = builder.append("values", Expressions.newArrayBounds(Object.class, 1, Expressions.constant(1)));
        builder.add(Expressions.statement(Expressions.call((Expression)Expressions.parameter(Scalar.class, "this"), BuiltInMethod.SCALAR_EXECUTE2.method, context_, values_)));
        builder.add(Expressions.return_(null, Expressions.arrayIndex(values_, Expressions.constant(0))));
        declarations.add(Expressions.methodDecl(1, Object.class, BuiltInMethod.SCALAR_EXECUTE1.method.getName(), ImmutableList.of(context_), builder.toBlock()));
        ClassDeclaration classDeclaration = Expressions.classDecl(1, "Buzz", null, ImmutableList.of(Scalar.class), declarations);
        String s = Expressions.toString(declarations, "\n", false);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            Util.debugCode(System.out, s);
        }
        try {
            return JaninoRexCompiler.getScalar(classDeclaration, s);
        }
        catch (IOException | CompileException e) {
            throw new RuntimeException(e);
        }
    }

    static Scalar getScalar(ClassDeclaration expr, String s) throws CompileException, IOException {
        ICompilerFactory compilerFactory;
        try {
            compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate java compiler", e);
        }
        IClassBodyEvaluator cbe = compilerFactory.newClassBodyEvaluator();
        cbe.setClassName(expr.name);
        cbe.setImplementedInterfaces(new Class[]{Scalar.class});
        cbe.setParentClassLoader(JaninoRexCompiler.class.getClassLoader());
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            cbe.setDebuggingInformation(true, true, true);
        }
        return (Scalar)cbe.createInstance(new StringReader(s));
    }
}

