/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;

public class EnumerableLimitSort
extends Sort
implements EnumerableRel {
    public EnumerableLimitSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, input, collation, offset, fetch);
        assert (this.getConvention() instanceof EnumerableConvention);
        assert (this.getConvention() == input.getConvention());
    }

    public static EnumerableLimitSort create(RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
        RelOptCluster cluster = input.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replace(collation);
        return new EnumerableLimitSort(cluster, traitSet, input, collation, offset, fetch);
    }

    @Override
    public EnumerableLimitSort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new EnumerableLimitSort(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), result.format);
        Expression childExp = builder.append("child", result.block);
        PhysType inputPhysType = result.physType;
        Pair<Expression, Expression> pair = inputPhysType.generateCollationKey(this.collation.getFieldCollations());
        Expression fetchVal = this.fetch == null ? Expressions.constant(Integer.MAX_VALUE) : EnumerableLimit.getExpression(this.fetch);
        Expression offsetVal = this.offset == null ? Expressions.constant(0) : EnumerableLimit.getExpression(this.offset);
        builder.add(Expressions.return_(null, Expressions.call(BuiltInMethod.ORDER_BY_WITH_FETCH_AND_OFFSET.method, Expressions.list(childExp, builder.append("keySelector", (Expression)pair.left)).appendIfNotNull(builder.appendIfNotNull("comparator", (Expression)pair.right)).appendIfNotNull(builder.appendIfNotNull("offset", Expressions.constant(offsetVal))).appendIfNotNull(builder.appendIfNotNull("fetch", Expressions.constant(fetchVal))))));
        return implementor.result(physType, builder.toBlock());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this.input);
        double toSort = this.getValue(this.fetch, rowCount);
        if (this.offset != null) {
            toSort += this.getValue(this.offset, rowCount);
        }
        toSort = Math.min(rowCount, toSort);
        double lookup = Math.max(1.0, Math.log(toSort));
        double bytesPerRow = (double)this.getRowType().getFieldCount() * 4.0;
        double cpu = rowCount * lookup * bytesPerRow;
        RelOptCost cost = planner.getCostFactory().makeCost(rowCount, cpu, 0.0);
        return cost;
    }

    private double getValue(RexNode r, double defaultValue) {
        if (r == null || r instanceof RexDynamicParam) {
            return defaultValue;
        }
        return RexLiteral.intValue(r);
    }
}

