/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.typeutils;

import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.LocalTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.NumericTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.table.planner.validate.ValidationFailure;
import org.apache.flink.table.planner.validate.ValidationResult;
import org.apache.flink.table.planner.validate.ValidationSuccess$;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.table.runtime.typeutils.DecimalDataTypeInfo;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;

public final class TypeInfoCheckUtils$ {
    public static final TypeInfoCheckUtils$ MODULE$;

    static {
        new TypeInfoCheckUtils$();
    }

    public boolean isNumeric(TypeInformation<?> dataType2) {
        boolean bl;
        TypeInformation<?> typeInformation = dataType2;
        if (typeInformation instanceof NumericTypeInfo) {
            bl = true;
        } else {
            BasicTypeInfo basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
            TypeInformation<?> typeInformation2 = typeInformation;
            boolean bl2 = !(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null) ? true : (typeInformation instanceof BigDecimalTypeInfo ? true : typeInformation instanceof DecimalDataTypeInfo);
            bl = bl2;
        }
        return bl;
    }

    public boolean isTemporal(TypeInformation<?> dataType2) {
        return this.isTimePoint(dataType2) || this.isTimeInterval(dataType2);
    }

    public boolean isTimePoint(TypeInformation<?> dataType2) {
        return dataType2 instanceof SqlTimeTypeInfo || dataType2 instanceof LocalTimeTypeInfo;
    }

    public boolean isTimeInterval(TypeInformation<?> dataType2) {
        return dataType2 instanceof TimeIntervalTypeInfo;
    }

    public boolean isArray(TypeInformation<?> dataType2) {
        TypeInformation<?> typeInformation = dataType2;
        boolean bl = typeInformation instanceof ObjectArrayTypeInfo ? true : (typeInformation instanceof BasicArrayTypeInfo ? true : typeInformation instanceof PrimitiveArrayTypeInfo);
        boolean bl2 = bl;
        return bl2;
    }

    public boolean isMap(TypeInformation<?> dataType2) {
        return dataType2 instanceof MapTypeInfo;
    }

    public ValidationResult assertNumericExpr(TypeInformation<?> dataType2, String caller) {
        ValidationResult validationResult;
        TypeInformation<?> typeInformation = dataType2;
        if (typeInformation instanceof NumericTypeInfo) {
            validationResult = ValidationSuccess$.MODULE$;
        } else {
            BasicTypeInfo basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
            TypeInformation<?> typeInformation2 = typeInformation;
            boolean bl = !(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null) ? true : (typeInformation instanceof BigDecimalTypeInfo ? true : typeInformation instanceof DecimalDataTypeInfo);
            validationResult = bl ? ValidationSuccess$.MODULE$ : new ValidationFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " requires numeric types, get ", " here"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{caller, dataType2})));
        }
        return validationResult;
    }

    public ValidationResult assertOrderableExpr(TypeInformation<?> dataType2, String caller) {
        return dataType2.isSortKeyType() ? ValidationSuccess$.MODULE$ : new ValidationFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " requires orderable types, get ", " here"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{caller, dataType2})));
    }

    public boolean isAssignable(Class<?>[] classArray, Class<?>[] toClassArray) {
        if (classArray.length != toClassArray.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (this.isAssignable(classArray[i], toClassArray[i])) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAssignable(Class<?> cls, Class<?> toClass) {
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (toClass.isPrimitive()) {
                if (Integer.TYPE.equals(cls)) {
                    return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
                }
                if (Long.TYPE.equals(cls)) {
                    return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
                }
                if (Boolean.TYPE.equals(cls)) {
                    return false;
                }
                if (Double.TYPE.equals(cls)) {
                    return false;
                }
                if (Float.TYPE.equals(cls)) {
                    return Double.TYPE.equals(toClass);
                }
                if (Character.TYPE.equals(cls)) {
                    return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
                }
                if (Short.TYPE.equals(cls)) {
                    return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
                }
                if (Byte.TYPE.equals(cls)) {
                    return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
                }
                return false;
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    private TypeInfoCheckUtils$() {
        MODULE$ = this;
    }
}

