/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecSink;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ChangelogModeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ChangelogModeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSinkSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StreamExecSink
extends CommonExecSink
implements StreamExecNode<Object> {
    public static final String FIELD_NAME_INPUT_CHANGELOG_MODE = "inputChangelogMode";
    public static final String FIELD_NAME_REQUIRE_UPSERT_MATERIALIZE = "requireUpsertMaterialize";
    @JsonProperty(value="inputChangelogMode")
    @JsonSerialize(using=ChangelogModeJsonSerializer.class)
    @JsonDeserialize(using=ChangelogModeJsonDeserializer.class)
    private final ChangelogMode inputChangelogMode;
    @JsonProperty(value="requireUpsertMaterialize")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final boolean upsertMaterialize;

    public StreamExecSink(DynamicTableSinkSpec tableSinkSpec, ChangelogMode inputChangelogMode, InputProperty inputProperty, LogicalType outputType, boolean upsertMaterialize, String description) {
        super(tableSinkSpec, tableSinkSpec.getTableSink().getChangelogMode(inputChangelogMode), false, StreamExecSink.getNewNodeId(), Collections.singletonList(inputProperty), outputType, description);
        this.inputChangelogMode = inputChangelogMode;
        this.upsertMaterialize = upsertMaterialize;
    }

    @JsonCreator
    public StreamExecSink(@JsonProperty(value="dynamicTableSink") DynamicTableSinkSpec tableSinkSpec, @JsonProperty(value="inputChangelogMode") ChangelogMode inputChangelogMode, @JsonProperty(value="id") int id, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") LogicalType outputType, @JsonProperty(value="requireUpsertMaterialize") boolean upsertMaterialize, @JsonProperty(value="description") String description) {
        super(tableSinkSpec, tableSinkSpec.getTableSink().getChangelogMode(inputChangelogMode), false, id, inputProperties, outputType, description);
        this.inputChangelogMode = inputChangelogMode;
        this.upsertMaterialize = upsertMaterialize;
    }

    @Override
    protected Transformation<Object> translateToPlanInternal(PlannerBase planner) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        ArrayList<Integer> rowtimeFieldIndices = new ArrayList<Integer>();
        for (int i2 = 0; i2 < inputRowType.getFieldCount(); ++i2) {
            if (!TypeCheckUtils.isRowTime((LogicalType)inputRowType.getTypeAt(i2))) continue;
            rowtimeFieldIndices.add(i2);
        }
        if (rowtimeFieldIndices.size() > 1) {
            throw new TableException(String.format("Found more than one rowtime field: [%s] in the query when insert into '%s'.\nPlease select the rowtime field that should be used as event-time timestamp for the DataStream by casting all other fields to TIMESTAMP.", rowtimeFieldIndices.stream().map(i -> (String)inputRowType.getFieldNames().get((int)i)).collect(Collectors.joining(", ")), this.tableSinkSpec.getObjectIdentifier().asSummaryString()));
        }
        int rowtimeFieldIndex = rowtimeFieldIndices.size() == 1 ? (Integer)rowtimeFieldIndices.get(0) : -1;
        return this.createSinkTransformation(planner.getExecEnv(), planner.getTableConfig(), inputTransform, rowtimeFieldIndex, this.upsertMaterialize);
    }
}

