/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Collections;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.python.PythonFunctionInfo;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.OverSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.CommonPythonUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.OverAggregateUtil;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamExecPythonOverAggregate
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamExecPythonOverAggregate.class);
    private static final String ARROW_PYTHON_OVER_WINDOW_RANGE_ROW_TIME_AGGREGATE_FUNCTION_OPERATOR_NAME = "org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.StreamArrowPythonRowTimeBoundedRangeOperator";
    private static final String ARROW_PYTHON_OVER_WINDOW_RANGE_PROC_TIME_AGGREGATE_FUNCTION_OPERATOR_NAME = "org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.StreamArrowPythonProcTimeBoundedRangeOperator";
    private static final String ARROW_PYTHON_OVER_WINDOW_ROWS_ROW_TIME_AGGREGATE_FUNCTION_OPERATOR_NAME = "org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.StreamArrowPythonRowTimeBoundedRowsOperator";
    private static final String ARROW_PYTHON_OVER_WINDOW_ROWS_PROC_TIME_AGGREGATE_FUNCTION_OPERATOR_NAME = "org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.StreamArrowPythonProcTimeBoundedRowsOperator";
    private final OverSpec overSpec;

    public StreamExecPythonOverAggregate(OverSpec overSpec, InputProperty inputProperty, RowType outputType, String description) {
        super(Collections.singletonList(inputProperty), (LogicalType)outputType, description);
        this.overSpec = overSpec;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        int rowTimeIdx;
        if (this.overSpec.getGroups().size() > 1) {
            throw new TableException("All aggregates must be computed on the same window.");
        }
        OverSpec.GroupSpec group = this.overSpec.getGroups().get(0);
        int[] orderKeys = group.getSort().getFieldIndices();
        boolean[] isAscendingOrders = group.getSort().getAscendingOrders();
        if (orderKeys.length != 1 || isAscendingOrders.length != 1) {
            throw new TableException("The window can only be ordered by a single time column.");
        }
        if (!isAscendingOrders[0]) {
            throw new TableException("The window can only be ordered in ASCENDING mode.");
        }
        int[] partitionKeys = this.overSpec.getPartition().getFieldIndices();
        TableConfig tableConfig = planner.getTableConfig();
        if (partitionKeys.length > 0 && tableConfig.getMinIdleStateRetentionTime() < 0L) {
            LOG.warn("No state retention interval configured for a query which accumulates state. Please provide a query configuration with valid retention interval to prevent excessive state size. You may specify a retention time of 0 to not clean up the state.");
        }
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        int orderKey = orderKeys[0];
        LogicalType orderKeyType = ((RowType.RowField)inputRowType.getFields().get(orderKey)).getType();
        if (LogicalTypeChecks.isRowtimeAttribute((LogicalType)orderKeyType)) {
            rowTimeIdx = orderKey;
        } else if (LogicalTypeChecks.isProctimeAttribute((LogicalType)orderKeyType)) {
            rowTimeIdx = -1;
        } else {
            throw new TableException("OVER windows' ordering in stream mode must be defined on a time attribute.");
        }
        if (group.getLowerBound().isPreceding() && group.getLowerBound().isUnbounded()) {
            throw new TableException("Python UDAF is not supported to be used in UNBOUNDED PRECEDING OVER windows.");
        }
        if (!group.getUpperBound().isCurrentRow()) {
            throw new TableException("Python UDAF is not supported to be used in UNBOUNDED FOLLOWING OVER windows.");
        }
        Object boundValue = OverAggregateUtil.getBoundary(this.overSpec, group.getLowerBound());
        if (boundValue instanceof BigDecimal) {
            throw new TableException("the specific value is decimal which haven not supported yet.");
        }
        long precedingOffset = -1L * (Long)boundValue;
        Configuration config = CommonPythonUtil.getMergedConfig(planner.getExecEnv(), tableConfig);
        OneInputTransformation<RowData, RowData> transform2 = this.createPythonOneInputTransformation(inputTransform, inputRowType, InternalTypeInfo.of((LogicalType)this.getOutputType()).toRowType(), rowTimeIdx, group.getAggCalls().toArray(new AggregateCall[0]), precedingOffset, group.isRows(), partitionKeys, tableConfig.getMinIdleStateRetentionTime(), tableConfig.getMaxIdleStateRetentionTime(), config);
        if (CommonPythonUtil.isPythonWorkerUsingManagedMemory(config)) {
            transform2.declareManagedMemoryUseCaseAtSlotScope(ManagedMemoryUseCase.PYTHON);
        }
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(partitionKeys, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)inputRowType));
        transform2.setStateKeySelector((KeySelector)selector);
        transform2.setStateKeyType((TypeInformation)selector.getProducedType());
        return transform2;
    }

    private OneInputTransformation<RowData, RowData> createPythonOneInputTransformation(Transformation<RowData> inputTransform, RowType inputRowType, RowType outputRowType, int rowTimeIdx, AggregateCall[] aggCalls, long lowerBoundary, boolean isRowsClause, int[] grouping, long minIdleStateRetentionTime, long maxIdleStateRetentionTime, Configuration config) {
        Tuple2<int[], PythonFunctionInfo[]> aggCallInfos = CommonPythonUtil.extractPythonAggregateFunctionInfosFromAggregateCall(aggCalls);
        int[] pythonUdafInputOffsets = (int[])aggCallInfos.f0;
        PythonFunctionInfo[] pythonFunctionInfos = (PythonFunctionInfo[])aggCallInfos.f1;
        OneInputStreamOperator<RowData, RowData> pythonOperator = this.getPythonOverWindowAggregateFunctionOperator(config, inputRowType, outputRowType, rowTimeIdx, lowerBoundary, isRowsClause, grouping, pythonUdafInputOffsets, pythonFunctionInfos, minIdleStateRetentionTime, maxIdleStateRetentionTime);
        return new OneInputTransformation(inputTransform, this.getDescription(), pythonOperator, (TypeInformation)InternalTypeInfo.of((RowType)outputRowType), inputTransform.getParallelism());
    }

    private OneInputStreamOperator<RowData, RowData> getPythonOverWindowAggregateFunctionOperator(Configuration config, RowType inputRowType, RowType outputRowType, int rowTiemIdx, long lowerBoundary, boolean isRowsClause, int[] grouping, int[] udafInputOffsets, PythonFunctionInfo[] pythonFunctionInfos, long minIdleStateRetentionTime, long maxIdleStateRetentionTime) {
        if (isRowsClause) {
            String className = rowTiemIdx != -1 ? ARROW_PYTHON_OVER_WINDOW_ROWS_ROW_TIME_AGGREGATE_FUNCTION_OPERATOR_NAME : ARROW_PYTHON_OVER_WINDOW_ROWS_PROC_TIME_AGGREGATE_FUNCTION_OPERATOR_NAME;
            Class clazz = CommonPythonUtil.loadClass(className);
            try {
                Constructor ctor = clazz.getConstructor(Configuration.class, Long.TYPE, Long.TYPE, PythonFunctionInfo[].class, RowType.class, RowType.class, Integer.TYPE, Long.TYPE, int[].class, int[].class);
                return (OneInputStreamOperator)ctor.newInstance(config, minIdleStateRetentionTime, maxIdleStateRetentionTime, pythonFunctionInfos, inputRowType, outputRowType, rowTiemIdx, lowerBoundary, grouping, udafInputOffsets);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new TableException("Python Arrow Over Rows Window Function Operator constructed failed.", (Throwable)e);
            }
        }
        String className = rowTiemIdx != -1 ? ARROW_PYTHON_OVER_WINDOW_RANGE_ROW_TIME_AGGREGATE_FUNCTION_OPERATOR_NAME : ARROW_PYTHON_OVER_WINDOW_RANGE_PROC_TIME_AGGREGATE_FUNCTION_OPERATOR_NAME;
        Class clazz = CommonPythonUtil.loadClass(className);
        try {
            Constructor ctor = clazz.getConstructor(Configuration.class, PythonFunctionInfo[].class, RowType.class, RowType.class, Integer.TYPE, Long.TYPE, int[].class, int[].class);
            return (OneInputStreamOperator)ctor.newInstance(config, pythonFunctionInfos, inputRowType, outputRowType, rowTiemIdx, lowerBoundary, grouping, udafInputOffsets);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TableException("Python Arrow Over Range Window Function Operator constructed failed.", (Throwable)e);
        }
    }
}

