/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.delegation.PlannerFactory;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.planner.delegation.BatchPlanner;
import org.apache.flink.table.planner.delegation.StreamPlanner;

@Internal
public final class BlinkPlannerFactory
implements PlannerFactory {
    public Planner create(Map<String, String> properties, Executor executor, TableConfig tableConfig, FunctionCatalog functionCatalog, CatalogManager catalogManager) {
        if (Boolean.valueOf(properties.getOrDefault("streaming-mode", "true")).booleanValue()) {
            return new StreamPlanner(executor, tableConfig, functionCatalog, catalogManager);
        }
        return new BatchPlanner(executor, tableConfig, functionCatalog, catalogManager);
    }

    public Map<String, String> optionalContext() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("class-name", this.getClass().getCanonicalName());
        return map;
    }

    public Map<String, String> requiredContext() {
        DescriptorProperties properties = new DescriptorProperties();
        return properties.asMap();
    }

    public List<String> supportedProperties() {
        return Arrays.asList("streaming-mode", "class-name");
    }
}

