/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.planner.delegation.BatchExecutor;
import org.apache.flink.table.planner.delegation.StreamExecutor;

@Internal
public class BlinkExecutorFactory
implements ExecutorFactory {
    public Executor create(Map<String, String> properties, StreamExecutionEnvironment executionEnvironment) {
        if (Boolean.valueOf(properties.getOrDefault("streaming-mode", "true")).booleanValue()) {
            return new StreamExecutor(executionEnvironment);
        }
        return new BatchExecutor(executionEnvironment);
    }

    public Executor create(Map<String, String> properties) {
        return this.create(properties, StreamExecutionEnvironment.getExecutionEnvironment());
    }

    public Map<String, String> requiredContext() {
        DescriptorProperties properties = new DescriptorProperties();
        return properties.asMap();
    }

    public List<String> supportedProperties() {
        return Arrays.asList("streaming-mode", "class-name");
    }

    public Map<String, String> optionalContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("class-name", this.getClass().getCanonicalName());
        return context;
    }
}

