/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser;

import java.util.LinkedHashMap;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.util.NlsString;
import org.apache.flink.sql.parser.SqlProperty;

public class SqlPartitionUtils {
    private SqlPartitionUtils() {
    }

    public static LinkedHashMap<String, String> getPartitionKVs(SqlNodeList partitionSpec) {
        if (partitionSpec == null) {
            return null;
        }
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (partitionSpec.size() == 0) {
            return ret;
        }
        for (SqlNode node : partitionSpec.getList()) {
            SqlProperty sqlProperty = (SqlProperty)node;
            Comparable comparable = SqlLiteral.value(sqlProperty.getValue());
            String value = comparable instanceof NlsString ? ((NlsString)comparable).getValue() : comparable.toString();
            ret.put(sqlProperty.getKey().getSimple(), value);
        }
        return ret;
    }
}

