/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.flink.calcite.shaded.com.google.common.collect.BoundType;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableRangeSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.Range;
import org.apache.flink.calcite.shaded.com.google.common.collect.RangeSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.TreeRangeSet;

public class RangeSets {
    private static final ImmutableRangeSet ALL = ImmutableRangeSet.of().complement();

    private RangeSets() {
    }

    public static <C extends Comparable<C>> RangeSet<C> minus(RangeSet<C> rangeSet, Range<C> range2) {
        TreeRangeSet<C> mutableRangeSet = TreeRangeSet.create(rangeSet);
        mutableRangeSet.remove(range2);
        return mutableRangeSet.equals(rangeSet) ? rangeSet : ImmutableRangeSet.copyOf(mutableRangeSet);
    }

    public static <C extends Comparable<C>> RangeSet<C> rangeSetAll() {
        return ALL;
    }

    public static <C extends Comparable<C>> int compare(RangeSet<C> s0, RangeSet<C> s1) {
        Range<C> r1;
        Range<C> r0;
        int c;
        Iterator<Range<C>> i0 = s0.asRanges().iterator();
        Iterator<Range<C>> i1 = s1.asRanges().iterator();
        do {
            boolean h0 = i0.hasNext();
            boolean h1 = i1.hasNext();
            if (h0 && h1) continue;
            return Boolean.compare(h0, h1);
        } while ((c = RangeSets.compare(r0 = i0.next(), r1 = i1.next())) == 0);
        return c;
    }

    public static <C extends Comparable<C>> int compare(Range<C> r0, Range<C> r1) {
        int c = Boolean.compare(r0.hasLowerBound(), r1.hasLowerBound());
        if (c != 0) {
            return c;
        }
        if (r0.hasLowerBound()) {
            c = r0.lowerEndpoint().compareTo(r1.lowerEndpoint());
            if (c != 0) {
                return c;
            }
            c = r0.lowerBoundType().compareTo(r1.lowerBoundType());
            if (c != 0) {
                return c;
            }
        }
        if ((c = Boolean.compare(r0.hasUpperBound(), r1.hasUpperBound())) != 0) {
            return -c;
        }
        if (r0.hasUpperBound()) {
            c = r0.upperEndpoint().compareTo(r1.upperEndpoint());
            if (c != 0) {
                return c;
            }
            c = r0.upperBoundType().compareTo(r1.upperBoundType());
            if (c != 0) {
                return c;
            }
        }
        return 0;
    }

    public static <C extends Comparable<C>> int hashCode(RangeSet<C> rangeSet) {
        int h = 1;
        for (Range<C> r : rangeSet.asRanges()) {
            h = 31 * h + r.hashCode();
        }
        return h;
    }

    public static <C extends Comparable<C>> boolean isPoint(Range<C> range2) {
        return range2.hasLowerBound() && range2.hasUpperBound() && range2.lowerEndpoint().equals(range2.upperEndpoint()) && !range2.isEmpty();
    }

    public static <C extends Comparable<C>> int countPoints(RangeSet<C> rangeSet) {
        int n = 0;
        for (Range<C> range2 : rangeSet.asRanges()) {
            if (!RangeSets.isPoint(range2)) continue;
            ++n;
        }
        return n;
    }

    public static <C extends Comparable<C>, C2 extends Comparable<C2>> RangeSet<C2> map(RangeSet<C> rangeSet, Handler<C, Range<C2>> handler) {
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        rangeSet.asRanges().forEach(range2 -> builder.add((Range)RangeSets.map(range2, handler)));
        return builder.build();
    }

    public static <C extends Comparable<C>, R> R map(Range<C> range2, Handler<C, R> handler) {
        if (range2.hasLowerBound() && range2.hasUpperBound()) {
            C lower = range2.lowerEndpoint();
            C upper = range2.upperEndpoint();
            if (range2.lowerBoundType() == BoundType.OPEN) {
                if (range2.upperBoundType() == BoundType.OPEN) {
                    return handler.open(lower, upper);
                }
                return handler.openClosed(lower, upper);
            }
            if (range2.upperBoundType() == BoundType.OPEN) {
                return handler.closedOpen(lower, upper);
            }
            if (lower.equals(upper)) {
                return handler.singleton(lower);
            }
            return handler.closed(lower, upper);
        }
        if (range2.hasLowerBound()) {
            C lower = range2.lowerEndpoint();
            if (range2.lowerBoundType() == BoundType.OPEN) {
                return handler.greaterThan(lower);
            }
            return handler.atLeast(lower);
        }
        if (range2.hasUpperBound()) {
            C upper = range2.upperEndpoint();
            if (range2.upperBoundType() == BoundType.OPEN) {
                return handler.lessThan(upper);
            }
            return handler.atMost(upper);
        }
        return handler.all();
    }

    public static <C extends Comparable<C>, C2 extends Comparable<C2>> RangeSet<C2> copy(RangeSet<C> rangeSet, final Function<C, C2> map) {
        return RangeSets.map(rangeSet, new CopyingHandler<C, C2>(){

            @Override
            C2 convert(C c) {
                return (Comparable)map.apply(c);
            }
        });
    }

    public static <C extends Comparable<C>, C2 extends Comparable<C2>> Range<C2> copy(Range<C> range2, final Function<C, C2> map) {
        return (Range)RangeSets.map(range2, new CopyingHandler<C, C2>(){

            @Override
            C2 convert(C c) {
                return (Comparable)map.apply(c);
            }
        });
    }

    public static <C extends Comparable<C>> void forEach(RangeSet<C> rangeSet, Consumer<C> consumer) {
        rangeSet.asRanges().forEach(range2 -> RangeSets.forEach(range2, consumer));
    }

    public static <C extends Comparable<C>> void forEach(Range<C> range2, Consumer<C> consumer) {
        if (range2.hasLowerBound() && range2.hasUpperBound()) {
            C lower = range2.lowerEndpoint();
            C upper = range2.upperEndpoint();
            if (range2.lowerBoundType() == BoundType.OPEN) {
                if (range2.upperBoundType() == BoundType.OPEN) {
                    consumer.open(lower, upper);
                } else {
                    consumer.openClosed(lower, upper);
                }
            } else if (range2.upperBoundType() == BoundType.OPEN) {
                consumer.closedOpen(lower, upper);
            } else if (lower.equals(upper)) {
                consumer.singleton(lower);
            } else {
                consumer.closed(lower, upper);
            }
        } else if (range2.hasLowerBound()) {
            C lower = range2.lowerEndpoint();
            if (range2.lowerBoundType() == BoundType.OPEN) {
                consumer.greaterThan(lower);
            } else {
                consumer.atLeast(lower);
            }
        } else if (range2.hasUpperBound()) {
            C upper = range2.upperEndpoint();
            if (range2.upperBoundType() == BoundType.OPEN) {
                consumer.lessThan(upper);
            } else {
                consumer.atMost(upper);
            }
        } else {
            consumer.all();
        }
    }

    public static <C extends Comparable<C>> Consumer<C> printer(StringBuilder sb, BiConsumer<StringBuilder, C> valuePrinter) {
        return new Printer<C>(sb, valuePrinter);
    }

    static class Printer<C extends Comparable<C>>
    implements Consumer<C> {
        private final StringBuilder sb;
        private final BiConsumer<StringBuilder, C> valuePrinter;

        Printer(StringBuilder sb, BiConsumer<StringBuilder, C> valuePrinter) {
            this.sb = sb;
            this.valuePrinter = valuePrinter;
        }

        @Override
        public void all() {
            this.sb.append("(-\u221e..+\u221e)");
        }

        @Override
        public void atLeast(C lower) {
            this.sb.append('[');
            this.valuePrinter.accept(this.sb, lower);
            this.sb.append("..+\u221e)");
        }

        @Override
        public void atMost(C upper) {
            this.sb.append("(-\u221e..");
            this.valuePrinter.accept(this.sb, upper);
            this.sb.append("]");
        }

        @Override
        public void greaterThan(C lower) {
            this.sb.append('(');
            this.valuePrinter.accept(this.sb, lower);
            this.sb.append("..+\u221e)");
        }

        @Override
        public void lessThan(C upper) {
            this.sb.append("(-\u221e..");
            this.valuePrinter.accept(this.sb, upper);
            this.sb.append(")");
        }

        @Override
        public void singleton(C value) {
            this.valuePrinter.accept(this.sb, value);
        }

        @Override
        public void closed(C lower, C upper) {
            this.sb.append('[');
            this.valuePrinter.accept(this.sb, lower);
            this.sb.append("..");
            this.valuePrinter.accept(this.sb, upper);
            this.sb.append(']');
        }

        @Override
        public void closedOpen(C lower, C upper) {
            this.sb.append('[');
            this.valuePrinter.accept(this.sb, lower);
            this.sb.append("..");
            this.valuePrinter.accept(this.sb, upper);
            this.sb.append(')');
        }

        @Override
        public void openClosed(C lower, C upper) {
            this.sb.append('(');
            this.valuePrinter.accept(this.sb, lower);
            this.sb.append("..");
            this.valuePrinter.accept(this.sb, upper);
            this.sb.append(']');
        }

        @Override
        public void open(C lower, C upper) {
            this.sb.append('(');
            this.valuePrinter.accept(this.sb, lower);
            this.sb.append("..");
            this.valuePrinter.accept(this.sb, upper);
            this.sb.append(')');
        }
    }

    private static abstract class CopyingHandler<C extends Comparable<C>, C2 extends Comparable<C2>>
    implements Handler<C, Range<C2>> {
        private CopyingHandler() {
        }

        abstract C2 convert(C var1);

        @Override
        public Range<C2> all() {
            return Range.all();
        }

        @Override
        public Range<C2> atLeast(C lower) {
            return Range.atLeast(this.convert(lower));
        }

        @Override
        public Range<C2> atMost(C upper) {
            return Range.atMost(this.convert(upper));
        }

        @Override
        public Range<C2> greaterThan(C lower) {
            return Range.greaterThan(this.convert(lower));
        }

        @Override
        public Range<C2> lessThan(C upper) {
            return Range.lessThan(this.convert(upper));
        }

        @Override
        public Range<C2> singleton(C value) {
            return Range.singleton(this.convert(value));
        }

        @Override
        public Range<C2> closed(C lower, C upper) {
            return Range.closed(this.convert(lower), this.convert(upper));
        }

        @Override
        public Range<C2> closedOpen(C lower, C upper) {
            return Range.closedOpen(this.convert(lower), this.convert(upper));
        }

        @Override
        public Range<C2> openClosed(C lower, C upper) {
            return Range.openClosed(this.convert(lower), this.convert(upper));
        }

        @Override
        public Range<C2> open(C lower, C upper) {
            return Range.open(this.convert(lower), this.convert(upper));
        }
    }

    public static interface Consumer<C extends Comparable<C>> {
        public void all();

        public void atLeast(C var1);

        public void atMost(C var1);

        public void greaterThan(C var1);

        public void lessThan(C var1);

        public void singleton(C var1);

        public void closed(C var1, C var2);

        public void closedOpen(C var1, C var2);

        public void openClosed(C var1, C var2);

        public void open(C var1, C var2);
    }

    public static interface Handler<C extends Comparable<C>, R> {
        public R all();

        public R atLeast(C var1);

        public R atMost(C var1);

        public R greaterThan(C var1);

        public R lessThan(C var1);

        public R singleton(C var1);

        public R closed(C var1, C var2);

        public R closedOpen(C var1, C var2);

        public R openClosed(C var1, C var2);

        public R open(C var1, C var2);
    }
}

