/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize.program;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkRuleSetProgram;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.Logging;
import org.apache.flink.table.planner.utils.Logging$class;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u0001M\u00111C\u00127j].\u001c\u0005.Y5oK\u0012\u0004&o\\4sC6T!a\u0001\u0003\u0002\u000fA\u0014xn\u001a:b[*\u0011QAB\u0001\t_B$\u0018.\\5{K*\u0011q\u0001C\u0001\u0005a2\fgN\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\u000b\u0003)\u0005\u001aB\u0001A\u000b\u001cUA\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\u00042\u0001H\u000f \u001b\u0005\u0011\u0011B\u0001\u0010\u0003\u0005Q1E.\u001b8l\u001fB$\u0018.\\5{KB\u0013xn\u001a:b[B\u0011\u0001%\t\u0007\u0001\t\u0015\u0011\u0003A1\u0001$\u0005\ty5)\u0005\u0002%OA\u0011a#J\u0005\u0003M]\u0011qAT8uQ&tw\r\u0005\u0002\u001dQ%\u0011\u0011F\u0001\u0002\u0015\r2Lgn[(qi&l\u0017N_3D_:$X\r\u001f;\u0011\u0005-rS\"\u0001\u0017\u000b\u00055B\u0011!B;uS2\u001c\u0018BA\u0018-\u0005\u001daunZ4j]\u001eDQ!\r\u0001\u0005\u0002I\na\u0001P5oSRtD#A\u001a\u0011\u0007q\u0001q\u0004C\u00046\u0001\t\u0007I\u0011\u0002\u001c\u0002\u0019A\u0014xn\u001a:b[:\u000bW.Z:\u0016\u0003]\u00022\u0001O\u001f@\u001b\u0005I$B\u0001\u001e<\u0003\u0011)H/\u001b7\u000b\u0003q\nAA[1wC&\u0011a(\u000f\u0002\n\u0003J\u0014\u0018-\u001f'jgR\u0004\"\u0001Q\"\u000f\u0005Y\t\u0015B\u0001\"\u0018\u0003\u0019\u0001&/\u001a3fM&\u0011A)\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t;\u0002BB$\u0001A\u0003%q'A\u0007qe><'/Y7OC6,7\u000f\t\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0003)\u0001(o\\4sC6l\u0015\r]\u000b\u0002\u0017B!\u0001\bT \u001c\u0013\ti\u0015HA\u0004ICNDW*\u00199\t\r=\u0003\u0001\u0015!\u0003L\u0003-\u0001(o\\4sC6l\u0015\r\u001d\u0011\t\u000b\u0015\u0001A\u0011A)\u0015\u0007ISF\f\u0005\u0002T16\tAK\u0003\u0002V-\u0006\u0019!/\u001a7\u000b\u0005]s\u0011aB2bY\u000eLG/Z\u0005\u00033R\u0013qAU3m\u001d>$W\rC\u0003\\!\u0002\u0007!+\u0001\u0003s_>$\b\"B/Q\u0001\u0004y\u0012aB2p]R,\u0007\u0010\u001e\u0005\u0006?\u0002!\t\u0001Y\u0001\u0004O\u0016$HCA1e!\r1\"mG\u0005\u0003G^\u0011aa\u00149uS>t\u0007\"B3_\u0001\u0004y\u0014\u0001\u00028b[\u0016DQa\u001a\u0001\u0005\u0002!\facZ3u\r2Lgn\u001b*vY\u0016\u001cV\r\u001e)s_\u001e\u0014\u0018-\u001c\u000b\u0003S6\u00042A\u00062k!\ra2nH\u0005\u0003Y\n\u00111C\u00127j].\u0014V\u000f\\3TKR\u0004&o\\4sC6DQ!\u001a4A\u0002}BQa\u001c\u0001\u0005\u0002A\fq!\u00193e\u0019\u0006\u001cH\u000fF\u0002riV\u0004\"A\u0006:\n\u0005M<\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006K:\u0004\ra\u0010\u0005\u0006\u00079\u0004\ra\u0007\u0005\u0006o\u0002!\t\u0001_\u0001\tC\u0012$g)\u001b:tiR\u0019\u0011/\u001f>\t\u000b\u00154\b\u0019A \t\u000b\r1\b\u0019A\u000e\t\u000bq\u0004A\u0011A?\u0002\u0013\u0005$GMQ3g_J,GCB9\u007f\u0003\u0003\t\u0019\u0001C\u0003\u0000w\u0002\u0007q(\u0001\u0007oC6,wJ\u001a\"fM>\u0014X\rC\u0003fw\u0002\u0007q\bC\u0003\u0004w\u0002\u00071\u0004C\u0004\u0002\b\u0001!\t!!\u0003\u0002\rI,Wn\u001c<f)\r\t\u00171\u0002\u0005\u0007K\u0006\u0015\u0001\u0019A \t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012\u0005yq-\u001a;Qe><'/Y7OC6,7/\u0006\u0002\u0002\u0014A!\u0001(!\u0006@\u0013\r\t9\"\u000f\u0002\u0005\u0019&\u001cH\u000f")
public class FlinkChainedProgram<OC extends FlinkOptimizeContext>
implements FlinkOptimizeProgram<OC>,
Logging {
    private final ArrayList<String> programNames;
    private final HashMap<String, FlinkOptimizeProgram<OC>> programMap;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        FlinkChainedProgram flinkChainedProgram = this;
        synchronized (flinkChainedProgram) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    private ArrayList<String> programNames() {
        return this.programNames;
    }

    private HashMap<String, FlinkOptimizeProgram<OC>> programMap() {
        return this.programMap;
    }

    @Override
    public RelNode optimize(RelNode root, OC context) {
        return (RelNode)JavaConversions$.MODULE$.asScalaBuffer(this.programNames()).foldLeft((Object)root, (Function2)new Serializable(this, context){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkChainedProgram $outer;
            private final FlinkOptimizeContext context$1;

            public final RelNode apply(RelNode input, String name) {
                FlinkOptimizeProgram program = (FlinkOptimizeProgram)this.$outer.get(name).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This should not happen."})).s((Seq)Nil$.MODULE$));
                    }
                });
                long start = System.currentTimeMillis();
                RelNode result = program.optimize(input, this.context$1);
                long end = System.currentTimeMillis();
                if (this.$outer.LOG().isDebugEnabled()) {
                    this.$outer.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"optimize ", " cost ", " ms.\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToLong((long)(end - start))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"optimize result: \\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FlinkRelOptUtil$.MODULE$.toString(result, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5())}))).toString());
                }
                return result;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.context$1 = context$1;
            }
        });
    }

    public Option<FlinkOptimizeProgram<OC>> get(String name) {
        return Option$.MODULE$.apply(this.programMap().get(name));
    }

    public Option<FlinkRuleSetProgram<OC>> getFlinkRuleSetProgram(String name) {
        None$ none$;
        Object object = this.get(name).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        });
        if (object instanceof FlinkRuleSetProgram) {
            FlinkRuleSetProgram flinkRuleSetProgram = (FlinkRuleSetProgram)object;
            none$ = new Some((Object)flinkRuleSetProgram);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean addLast(String name, FlinkOptimizeProgram<OC> program) {
        boolean bl;
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(program);
        if (this.programNames().contains(name)) {
            bl = false;
        } else {
            this.programNames().add(name);
            this.programMap().put(name, program);
            bl = true;
        }
        return bl;
    }

    public boolean addFirst(String name, FlinkOptimizeProgram<OC> program) {
        boolean bl;
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(program);
        if (this.programNames().contains(name)) {
            bl = false;
        } else {
            this.programNames().add(0, name);
            this.programMap().put(name, program);
            bl = true;
        }
        return bl;
    }

    public boolean addBefore(String nameOfBefore, String name, FlinkOptimizeProgram<OC> program) {
        boolean bl;
        Preconditions.checkNotNull((Object)nameOfBefore);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(program);
        if (!this.programNames().contains(name) && this.programNames().contains(nameOfBefore)) {
            if (this.programNames().isEmpty()) {
                bl = this.addLast(name, program);
            } else {
                int index = this.programNames().indexOf(nameOfBefore);
                this.programNames().add(index, name);
                this.programMap().put(name, program);
                bl = true;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public Option<FlinkOptimizeProgram<OC>> remove(String name) {
        this.programNames().remove(name);
        return Option$.MODULE$.apply(this.programMap().remove(name));
    }

    public List<String> getProgramNames() {
        return new ArrayList<String>(this.programNames());
    }

    public FlinkChainedProgram() {
        Logging$class.$init$(this);
        this.programNames = new ArrayList();
        this.programMap = new HashMap();
    }
}

