/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.logical;

import java.time.Duration;
import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeUtils;

@JsonTypeName(value="CumulativeWindow")
public class CumulativeWindowSpec
implements WindowSpec {
    public static final String FIELD_NAME_MAX_SIZE = "maxSize";
    public static final String FIELD_NAME_STEP = "step";
    @JsonProperty(value="maxSize")
    private final Duration maxSize;
    @JsonProperty(value="step")
    private final Duration step;

    @JsonCreator
    public CumulativeWindowSpec(@JsonProperty(value="maxSize") Duration maxSize, @JsonProperty(value="step") Duration step) {
        this.maxSize = (Duration)Preconditions.checkNotNull((Object)maxSize);
        this.step = (Duration)Preconditions.checkNotNull((Object)step);
    }

    @Override
    public String toSummaryString(String windowing) {
        return String.format("CUMULATE(%s, max_size=[%s], step=[%s])", windowing, TimeUtils.formatWithHighestUnit((Duration)this.maxSize), TimeUtils.formatWithHighestUnit((Duration)this.step));
    }

    public Duration getMaxSize() {
        return this.maxSize;
    }

    public Duration getStep() {
        return this.step;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CumulativeWindowSpec that = (CumulativeWindowSpec)o;
        return this.maxSize.equals(that.maxSize) && this.step.equals(that.step);
    }

    public int hashCode() {
        return Objects.hash(CumulativeWindowSpec.class, this.maxSize, this.step);
    }

    public String toString() {
        return String.format("CUMULATE(max_size=[%s], step=[%s])", TimeUtils.formatWithHighestUnit((Duration)this.maxSize), TimeUtils.formatWithHighestUnit((Duration)this.step));
    }
}

