/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.calls;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext$;
import org.apache.flink.table.planner.codegen.CollectorCodeGenerator$;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.GeneratedExpression$;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil$;
import org.apache.flink.table.runtime.collector.WrappingCollector;
import org.apache.flink.table.runtime.generated.GeneratedCollector;
import org.apache.flink.table.runtime.operators.join.lookup.DelegatingResultFuture;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class BridgingFunctionGenUtil$ {
    public static final BridgingFunctionGenUtil$ MODULE$;

    static {
        new BridgingFunctionGenUtil$();
    }

    public GeneratedExpression generateFunctionAwareCall(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, LogicalType returnType, TypeInference inference, CallContext callContext, UserDefinedFunction udf, String functionName, boolean skipIfArgsNull) {
        Tuple2<GeneratedExpression, DataType> tuple2 = this.generateFunctionAwareCallWithDataType(ctx, operands, returnType, inference, callContext, udf, functionName, skipIfArgsNull);
        if (tuple2 != null) {
            GeneratedExpression call;
            GeneratedExpression generatedExpression;
            GeneratedExpression call2 = generatedExpression = (call = (GeneratedExpression)tuple2._1());
            return call2;
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<GeneratedExpression, DataType> generateFunctionAwareCallWithDataType(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, LogicalType returnType, TypeInference inference, CallContext callContext, UserDefinedFunction udf, String functionName, boolean skipIfArgsNull) {
        CallContext adaptedCallContext = TypeInferenceUtil.adaptArguments((TypeInference)inference, (CallContext)callContext, null);
        Seq enrichedArgumentDataTypes = JavaScalaConversionUtil$.MODULE$.toScala(adaptedCallContext.getArgumentDataTypes());
        this.verifyArgumentTypes((Seq<LogicalType>)((Seq)operands.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LogicalType apply(GeneratedExpression x$1) {
                return x$1.resultType();
            }
        }, Seq$.MODULE$.canBuildFrom())), enrichedArgumentDataTypes);
        DataType enrichedOutputDataType = TypeInferenceUtil.inferOutputType((CallContext)adaptedCallContext, (TypeStrategy)inference.getOutputTypeStrategy());
        this.verifyFunctionAwareOutputType(returnType, enrichedOutputDataType, udf);
        this.verifyFunctionAwareImplementation(enrichedArgumentDataTypes, enrichedOutputDataType, udf, functionName);
        GeneratedExpression call = this.generateFunctionAwareCall(ctx, operands, enrichedArgumentDataTypes, enrichedOutputDataType, returnType, udf, skipIfArgsNull);
        return new Tuple2((Object)call, (Object)enrichedOutputDataType);
    }

    private GeneratedExpression generateFunctionAwareCall(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, Seq<DataType> argumentDataTypes, DataType outputDataType, LogicalType returnType, UserDefinedFunction udf, boolean skipIfArgsNull) {
        GeneratedExpression generatedExpression;
        String functionTerm = ctx.addReusableFunction(udf, ctx.addReusableFunction$default$2(), ctx.addReusableFunction$default$3());
        Seq<GeneratedExpression> externalOperands = this.prepareExternalOperands(ctx, operands, argumentDataTypes);
        FunctionKind functionKind = udf.getKind();
        FunctionKind functionKind2 = FunctionKind.TABLE;
        if (!(functionKind != null ? !functionKind.equals(functionKind2) : functionKind2 != null)) {
            generatedExpression = this.generateTableFunctionCall(ctx, functionTerm, externalOperands, outputDataType, returnType, skipIfArgsNull);
        } else {
            FunctionKind functionKind3 = udf.getKind();
            FunctionKind functionKind4 = FunctionKind.ASYNC_TABLE;
            generatedExpression = !(functionKind3 != null ? !functionKind3.equals(functionKind4) : functionKind4 != null) ? this.generateAsyncTableFunctionCall(ctx, functionTerm, externalOperands, returnType) : this.generateScalarFunctionCall(ctx, functionTerm, externalOperands, outputDataType);
        }
        return generatedExpression;
    }

    private GeneratedExpression generateTableFunctionCall(CodeGeneratorContext ctx, String functionTerm, Seq<GeneratedExpression> externalOperands, DataType functionOutputDataType, LogicalType outputType, boolean skipIfArgsNull) {
        String resultCollectorTerm = this.generateResultCollector(ctx, functionOutputDataType, outputType);
        String setCollectorCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      |", ".setCollector(", ");\n      |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{functionTerm, resultCollectorTerm})))).stripMargin();
        ctx.addReusableOpenStatement(setCollectorCode);
        String functionCallCode = skipIfArgsNull ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |", "\n        |if (", ") {\n        |  // skip\n        |} else {\n        |  ", ".eval(", ");\n        |}\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)externalOperands.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GeneratedExpression x$2) {
                return x$2.code();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n"), ((TraversableOnce)externalOperands.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GeneratedExpression x$3) {
                return x$3.nullTerm();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(" || "), functionTerm, ((TraversableOnce)externalOperands.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GeneratedExpression x$4) {
                return x$4.resultTerm();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})))).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |", "\n        |", ".eval(", ");\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)externalOperands.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GeneratedExpression x$5) {
                return x$5.code();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n"), functionTerm, ((TraversableOnce)externalOperands.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GeneratedExpression x$6) {
                return x$6.resultTerm();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})))).stripMargin();
        return new GeneratedExpression(resultCollectorTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), functionCallCode, outputType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    private GeneratedExpression generateAsyncTableFunctionCall(CodeGeneratorContext ctx, String functionTerm, Seq<GeneratedExpression> externalOperands, LogicalType outputType) {
        String DELEGATE = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(DelegatingResultFuture.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        String functionCallCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |", "\n        |if (", ") {\n        |  ", ".complete(java.util.Collections.emptyList());\n        |} else {\n        |  ", " delegates = new ", "(", ");\n        |  ", ".eval(\n        |    delegates.getCompletableFuture(),\n        |    ", ");\n        |}\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)externalOperands.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GeneratedExpression x$7) {
                return x$7.code();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n"), ((TraversableOnce)externalOperands.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GeneratedExpression x$8) {
                return x$8.nullTerm();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(" || "), CodeGenUtils$.MODULE$.DEFAULT_COLLECTOR_TERM(), DELEGATE, DELEGATE, CodeGenUtils$.MODULE$.DEFAULT_COLLECTOR_TERM(), functionTerm, ((TraversableOnce)externalOperands.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GeneratedExpression x$9) {
                return x$9.resultTerm();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})))).stripMargin();
        return new GeneratedExpression(GeneratedExpression$.MODULE$.NO_CODE(), GeneratedExpression$.MODULE$.NEVER_NULL(), functionCallCode, outputType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    private String generateResultCollector(CodeGeneratorContext ctx, DataType outputDataType, LogicalType returnType) {
        String string;
        LogicalType outputType = outputDataType.getLogicalType();
        CodeGeneratorContext collectorCtx = CodeGeneratorContext$.MODULE$.apply(ctx.tableConfig());
        String externalResultTerm = CodeGenUtils$.MODULE$.newName("externalResult");
        if (LogicalTypeChecks.isCompositeType((LogicalType)outputType)) {
            string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |if (", " != null) {\n        |  outputResult(", ");\n        |}\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{externalResultTerm, externalResultTerm})))).stripMargin();
        } else {
            ExprCodeGenerator qual$1 = new ExprCodeGenerator(collectorCtx, outputType.isNullable());
            LogicalType x$16 = outputType;
            String x$17 = externalResultTerm;
            Option<int[]> x$18 = qual$1.bindInput$default$3();
            ExprCodeGenerator resultGenerator = qual$1.bindInput(x$16, x$17, x$18);
            GeneratedExpression wrappedResult = resultGenerator.generateConverterResultExpression((RowType)returnType, GenericRowData.class, resultGenerator.generateConverterResultExpression$default$3(), resultGenerator.generateConverterResultExpression$default$4(), resultGenerator.generateConverterResultExpression$default$5(), resultGenerator.generateConverterResultExpression$default$6(), resultGenerator.generateConverterResultExpression$default$7());
            string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |", "\n       |outputResult(", ");\n       |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{wrappedResult.code(), wrappedResult.resultTerm()})))).stripMargin();
        }
        String collectorCode = string;
        GeneratedCollector<WrappingCollector<?>> resultCollector = CollectorCodeGenerator$.MODULE$.generateWrappingCollector(collectorCtx, "TableFunctionResultConverterCollector", outputType, externalResultTerm, CodeGenUtils$.MODULE$.genToInternalConverter(ctx, outputDataType), collectorCode);
        String resultCollectorTerm = CodeGenUtils$.MODULE$.newName("resultConverterCollector");
        CollectorCodeGenerator$.MODULE$.addToContext(ctx, resultCollectorTerm, resultCollector);
        return resultCollectorTerm;
    }

    private GeneratedExpression generateScalarFunctionCall(CodeGeneratorContext ctx, String functionTerm, Seq<GeneratedExpression> externalOperands, DataType outputDataType) {
        Class externalResultClass = outputDataType.getConversionClass();
        String externalResultTypeTerm = CodeGenUtils$.MODULE$.typeTerm(externalResultClass);
        Class externalResultClassBoxed = ExtractionUtils.primitiveToWrapper((Class)externalResultClass);
        Class clazz = externalResultClass;
        Class clazz2 = externalResultClassBoxed;
        String externalResultCasting = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{externalResultTypeTerm})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{externalResultTypeTerm, CodeGenUtils$.MODULE$.typeTerm(externalResultClassBoxed)}));
        String externalResultTerm = ctx.addReusableLocalVariable(externalResultTypeTerm, "externalResult");
        GeneratedExpression internalExpr = CodeGenUtils$.MODULE$.genToInternalConverterAll(ctx, outputDataType, externalResultTerm);
        String x$19 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |", "\n        |", " = ", " ", "\n        |  .", "(", ");\n        |", "\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)externalOperands.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GeneratedExpression x$10) {
                return x$10.code();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n"), externalResultTerm, externalResultCasting, functionTerm, "eval", ((TraversableOnce)externalOperands.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GeneratedExpression x$11) {
                return x$11.resultTerm();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", "), internalExpr.code()})))).stripMargin();
        String x$20 = internalExpr.copy$default$1();
        String x$21 = internalExpr.copy$default$2();
        LogicalType x$22 = internalExpr.copy$default$4();
        Option<Object> x$23 = internalExpr.copy$default$5();
        return internalExpr.copy(x$20, x$21, x$19, x$22, x$23);
    }

    private Seq<GeneratedExpression> prepareExternalOperands(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, Seq<DataType> argumentDataTypes) {
        return (Seq)((TraversableLike)operands.zip(argumentDataTypes, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(ctx){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$1;

            public final GeneratedExpression apply(Tuple2<GeneratedExpression, DataType> x0$1) {
                Tuple2<GeneratedExpression, DataType> tuple2 = x0$1;
                if (tuple2 != null) {
                    GeneratedExpression operand = (GeneratedExpression)tuple2._1();
                    DataType dataType2 = (DataType)tuple2._2();
                    GeneratedExpression generatedExpression = operand.copy(CodeGenUtils$.MODULE$.genToExternalConverterAll(this.ctx$1, dataType2, operand), operand.copy$default$2(), operand.copy$default$3(), operand.copy$default$4(), operand.copy$default$5());
                    return generatedExpression;
                }
                throw new MatchError(tuple2);
            }
            {
                this.ctx$1 = ctx$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private void verifyArgumentTypes(Seq<LogicalType> operandTypes, Seq<DataType> enrichedDataTypes) {
        Seq enrichedTypes = (Seq)enrichedDataTypes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LogicalType apply(DataType x$12) {
                return x$12.getLogicalType();
            }
        }, Seq$.MODULE$.canBuildFrom());
        ((IterableLike)operandTypes.zip((GenIterable)enrichedTypes, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<LogicalType, LogicalType> x0$2) {
                Tuple2<LogicalType, LogicalType> tuple2 = x0$2;
                if (tuple2 != null) {
                    LogicalType enrichedType;
                    LogicalType operandType = (LogicalType)tuple2._1();
                    if (LogicalTypeCasts.supportsAvoidingCast((LogicalType)operandType, (LogicalType)(enrichedType = (LogicalType)tuple2._2()))) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new CodeGenException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mismatch of function's argument data type '", "' and actual "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{enrichedType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"argument type '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operandType}))).toString());
                }
                throw new MatchError(tuple2);
            }
        });
        enrichedDataTypes.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(DataType x$1) {
                DataTypeUtils.validateOutputDataType((DataType)x$1);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private void verifyFunctionAwareOutputType(LogicalType returnType, DataType enrichedDataType, UserDefinedFunction udf) {
        block6: {
            block5: {
                LogicalType enrichedType = enrichedDataType.getLogicalType();
                FunctionKind functionKind = udf.getKind();
                FunctionKind functionKind2 = FunctionKind.TABLE;
                if (!(functionKind != null ? !functionKind.equals(functionKind2) : functionKind2 != null) && !LogicalTypeChecks.isCompositeType((LogicalType)enrichedType)) {
                    Preconditions.checkState((LogicalTypeChecks.hasRoot((LogicalType)returnType, (LogicalTypeRoot)LogicalTypeRoot.ROW) && returnType.getChildren().size() == 1 ? 1 : 0) != 0, (String)"Logical output type of function call should be a ROW wrapping an atomic type.", (Object[])ScalaRunTime$.MODULE$.toObjectArray(((TraversableOnce)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)).toArray(ClassTag$.MODULE$.Any())));
                    LogicalType atomicOutputType = (LogicalType)((RowType)returnType).getChildren().get(0);
                    this.verifyOutputType(atomicOutputType, enrichedDataType, udf);
                    return;
                }
                FunctionKind functionKind3 = udf.getKind();
                FunctionKind functionKind4 = FunctionKind.ASYNC_TABLE;
                if (!(functionKind3 != null ? !functionKind3.equals(functionKind4) : functionKind4 != null) && !LogicalTypeChecks.isCompositeType((LogicalType)enrichedType)) {
                    throw new CodeGenException("Async table functions must not emit an atomic type. Only a composite type such as the row type are supported.");
                }
                FunctionKind functionKind5 = udf.getKind();
                FunctionKind functionKind6 = FunctionKind.TABLE;
                if (!(functionKind5 == null ? functionKind6 != null : !functionKind5.equals(functionKind6))) break block5;
                FunctionKind functionKind7 = udf.getKind();
                FunctionKind functionKind8 = FunctionKind.ASYNC_TABLE;
                if (functionKind7 != null ? !functionKind7.equals(functionKind8) : functionKind8 != null) break block6;
            }
            this.verifyOutputType(returnType.copy(true), enrichedDataType, udf);
            return;
        }
        this.verifyOutputType(returnType, enrichedDataType, udf);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyOutputType(LogicalType returnType, DataType enrichedDataType, UserDefinedFunction udf) {
        void var4_4;
        LogicalType enrichedType = enrichedDataType.getLogicalType();
        if (LogicalTypeCasts.supportsAvoidingCast((LogicalType)enrichedType, (LogicalType)returnType)) {
            DataTypeUtils.validateInputDataType((DataType)enrichedDataType);
            return;
        }
        throw new CodeGenException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mismatch of expected output data type '", "' and function's "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{returnType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"output type '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var4_4}))).toString());
    }

    public void verifyFunctionAwareImplementation(Seq<DataType> argumentDataTypes, DataType outputDataType, UserDefinedFunction udf, String functionName) {
        block5: {
            block3: {
                block4: {
                    block2: {
                        FunctionKind functionKind = udf.getKind();
                        FunctionKind functionKind2 = FunctionKind.TABLE;
                        if (functionKind != null ? !functionKind.equals(functionKind2) : functionKind2 != null) break block2;
                        this.verifyImplementation("eval", argumentDataTypes, (Option<DataType>)None$.MODULE$, udf, functionName);
                        break block3;
                    }
                    FunctionKind functionKind = udf.getKind();
                    FunctionKind functionKind3 = FunctionKind.ASYNC_TABLE;
                    if (functionKind != null ? !functionKind.equals(functionKind3) : functionKind3 != null) break block4;
                    DataType dataType2 = (DataType)DataTypes.NULL().bridgedTo(CompletableFuture.class);
                    this.verifyImplementation("eval", (Seq<DataType>)((Seq)argumentDataTypes.$plus$colon((Object)dataType2, Seq$.MODULE$.canBuildFrom())), (Option<DataType>)None$.MODULE$, udf, functionName);
                    break block3;
                }
                FunctionKind functionKind = udf.getKind();
                FunctionKind functionKind4 = FunctionKind.SCALAR;
                if (functionKind != null ? !functionKind.equals(functionKind4) : functionKind4 != null) break block5;
                this.verifyImplementation("eval", argumentDataTypes, (Option<DataType>)new Some((Object)outputDataType), udf, functionName);
            }
            return;
        }
        throw new CodeGenException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported function kind '", "' for function '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{udf.getKind(), functionName})));
    }

    private void verifyImplementation(String methodName, Seq<DataType> argumentDataTypes, Option<DataType> outputDataType, UserDefinedFunction udf, String functionName) {
        Class[] argumentClasses = (Class[])((TraversableOnce)argumentDataTypes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<?> apply(DataType x$14) {
                return x$14.getConversionClass();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class));
        Class outputClass = (Class)outputDataType.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<?> apply(DataType x$15) {
                return x$15.getConversionClass();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<BoxedUnit> apply() {
                return BoxedUnit.TYPE;
            }
        });
        UserDefinedFunctionHelper.validateClassForRuntime(udf.getClass(), (String)methodName, (Class[])argumentClasses, (Class)outputClass, (String)functionName);
    }

    private BridgingFunctionGenUtil$() {
        MODULE$ = this;
    }
}

