/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlAggFunction;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.functions.utils.HiveAggSqlFunction;
import org.apache.flink.table.planner.functions.utils.HiveFunctionUtils;
import org.apache.flink.table.planner.functions.utils.HiveTableSqlFunction;
import org.apache.flink.table.planner.functions.utils.TableSqlFunction;
import org.apache.flink.table.planner.functions.utils.UserDefinedFunctionUtils;
import org.apache.flink.table.planner.plan.schema.DeferredTypeFlinkTableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;

@Internal
public class FunctionCatalogOperatorTable
implements SqlOperatorTable {
    private final FunctionCatalog functionCatalog;
    private final DataTypeFactory dataTypeFactory;
    private final FlinkTypeFactory typeFactory;

    public FunctionCatalogOperatorTable(FunctionCatalog functionCatalog, DataTypeFactory dataTypeFactory, FlinkTypeFactory typeFactory) {
        this.functionCatalog = functionCatalog;
        this.dataTypeFactory = dataTypeFactory;
        this.typeFactory = typeFactory;
    }

    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        if (opName.isStar()) {
            return;
        }
        UnresolvedIdentifier identifier = UnresolvedIdentifier.of(opName.names);
        this.functionCatalog.lookupFunction(identifier).flatMap(lookupResult -> this.convertToSqlFunction(category, lookupResult.getFunctionIdentifier(), lookupResult.getFunctionDefinition())).ifPresent(operatorList::add);
    }

    private Optional<SqlFunction> convertToSqlFunction(@Nullable SqlFunctionCategory category, FunctionIdentifier identifier, FunctionDefinition definition) {
        if (definition instanceof AggregateFunctionDefinition) {
            AggregateFunctionDefinition def = (AggregateFunctionDefinition)definition;
            if (HiveFunctionUtils.isHiveFunc(def.getAggregateFunction())) {
                return Optional.of(new HiveAggSqlFunction(identifier, def.getAggregateFunction(), this.typeFactory));
            }
            return this.convertAggregateFunction(identifier, (AggregateFunctionDefinition)definition);
        }
        if (definition instanceof ScalarFunctionDefinition) {
            ScalarFunctionDefinition def = (ScalarFunctionDefinition)definition;
            return this.convertScalarFunction(identifier, def);
        }
        if (definition instanceof TableFunctionDefinition && category != null && category.isTableFunction()) {
            TableFunctionDefinition def = (TableFunctionDefinition)definition;
            if (HiveFunctionUtils.isHiveFunc(def.getTableFunction())) {
                DataType returnType = TypeConversions.fromLegacyInfoToDataType((TypeInformation)new GenericTypeInfo(Row.class));
                return Optional.of(new HiveTableSqlFunction(identifier, def.getTableFunction(), returnType, this.typeFactory, new DeferredTypeFlinkTableFunction(def.getTableFunction(), returnType), HiveTableSqlFunction.operandTypeChecker(identifier.toString(), def.getTableFunction())));
            }
            return this.convertTableFunction(identifier, (TableFunctionDefinition)definition);
        }
        return this.convertToBridgingSqlFunction(category, identifier, definition);
    }

    private Optional<SqlFunction> convertToBridgingSqlFunction(@Nullable SqlFunctionCategory category, FunctionIdentifier identifier, FunctionDefinition definition) {
        TypeInference typeInference;
        if (!this.verifyFunctionKind(category, identifier, definition)) {
            return Optional.empty();
        }
        try {
            typeInference = definition.getTypeInference(this.dataTypeFactory);
        }
        catch (Throwable t) {
            throw new ValidationException(String.format("An error occurred in the type inference logic of function '%s'.", identifier.asSummaryString()), t);
        }
        if (typeInference.getOutputTypeStrategy() == TypeStrategies.MISSING) {
            return Optional.empty();
        }
        SqlFunction function = definition.getKind() == FunctionKind.AGGREGATE || definition.getKind() == FunctionKind.TABLE_AGGREGATE ? BridgingSqlAggFunction.of(this.dataTypeFactory, this.typeFactory, SqlKind.OTHER_FUNCTION, identifier, definition, typeInference) : BridgingSqlFunction.of(this.dataTypeFactory, this.typeFactory, SqlKind.OTHER_FUNCTION, identifier, definition, typeInference);
        return Optional.of(function);
    }

    private boolean verifyFunctionKind(@Nullable SqlFunctionCategory category, FunctionIdentifier identifier, FunctionDefinition definition) {
        BuiltInFunctionDefinition builtInFunction;
        if (definition instanceof BuiltInFunctionDefinition && !(builtInFunction = (BuiltInFunctionDefinition)definition).getRuntimeClass().isPresent()) {
            return false;
        }
        FunctionKind kind = definition.getKind();
        if (kind == FunctionKind.TABLE) {
            return true;
        }
        if (kind == FunctionKind.SCALAR || kind == FunctionKind.AGGREGATE || kind == FunctionKind.TABLE_AGGREGATE) {
            if (category != null && category.isTableFunction()) {
                throw new ValidationException(String.format("Function '%s' cannot be used as a table function.", identifier.asSummaryString()));
            }
            return true;
        }
        return false;
    }

    private Optional<SqlFunction> convertAggregateFunction(FunctionIdentifier identifier, AggregateFunctionDefinition functionDefinition) {
        SqlFunction aggregateFunction = UserDefinedFunctionUtils.createAggregateSqlFunction(identifier, identifier.toString(), functionDefinition.getAggregateFunction(), TypeConversions.fromLegacyInfoToDataType((TypeInformation)functionDefinition.getResultTypeInfo()), TypeConversions.fromLegacyInfoToDataType((TypeInformation)functionDefinition.getAccumulatorTypeInfo()), this.typeFactory);
        return Optional.of(aggregateFunction);
    }

    private Optional<SqlFunction> convertScalarFunction(FunctionIdentifier identifier, ScalarFunctionDefinition functionDefinition) {
        SqlFunction scalarFunction = UserDefinedFunctionUtils.createScalarSqlFunction(identifier, identifier.toString(), functionDefinition.getScalarFunction(), this.typeFactory);
        return Optional.of(scalarFunction);
    }

    private Optional<SqlFunction> convertTableFunction(FunctionIdentifier identifier, TableFunctionDefinition functionDefinition) {
        TableSqlFunction tableFunction = UserDefinedFunctionUtils.createTableSqlFunction(identifier, identifier.toString(), functionDefinition.getTableFunction(), TypeConversions.fromLegacyInfoToDataType((TypeInformation)functionDefinition.getResultType()), this.typeFactory);
        return Optional.of(tableFunction);
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        throw new UnsupportedOperationException("This should never be called");
    }
}

