/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.sinks;

import java.util.UUID;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.operators.collect.CollectResultIterator;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperator;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperatorFactory;
import org.apache.flink.streaming.api.operators.collect.CollectStreamSink;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.internal.SelectResultProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.sinks.StreamTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public abstract class SelectTableSinkBase<T>
implements StreamTableSink<T> {
    private final TableSchema tableSchema;
    protected final DataFormatConverters.DataFormatConverter<RowData, Row> converter;
    private final TypeSerializer<T> typeSerializer;
    private CollectResultIterator<T> iterator;

    public SelectTableSinkBase(TableSchema schema, TypeSerializer<T> typeSerializer) {
        this.tableSchema = schema;
        this.converter = DataFormatConverters.getConverterForDataType((DataType)this.tableSchema.toPhysicalRowDataType());
        this.typeSerializer = typeSerializer;
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    public TableSink<T> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        throw new UnsupportedOperationException();
    }

    public DataStreamSink<?> consumeDataStream(DataStream<T> dataStream) {
        StreamExecutionEnvironment env = dataStream.getExecutionEnvironment();
        String accumulatorName = "tableResultCollect_" + UUID.randomUUID();
        CollectSinkOperatorFactory factory = new CollectSinkOperatorFactory(this.typeSerializer, accumulatorName);
        CollectSinkOperator operator = (CollectSinkOperator)factory.getOperator();
        this.iterator = new CollectResultIterator(operator.getOperatorIdFuture(), this.typeSerializer, accumulatorName, env.getCheckpointConfig());
        CollectStreamSink sink = new CollectStreamSink(dataStream, factory);
        env.addOperator((Transformation)sink.getTransformation());
        return sink.name("Select table sink");
    }

    public SelectResultProvider getSelectResultProvider() {
        return new SelectResultProvider(){

            public void setJobClient(JobClient jobClient) {
                SelectTableSinkBase.this.iterator.setJobClient(jobClient);
            }

            public CloseableIterator<Row> getResultIterator() {
                return new RowIteratorWrapper(SelectTableSinkBase.this.iterator);
            }
        };
    }

    protected abstract Row convertToRow(T var1);

    protected static InternalTypeInfo<RowData> createTypeInfo(TableSchema tableSchema) {
        return InternalTypeInfo.of((LogicalType)tableSchema.toRowDataType().getLogicalType());
    }

    private class RowIteratorWrapper
    implements CloseableIterator<Row> {
        private final CollectResultIterator<T> iterator;

        public RowIteratorWrapper(CollectResultIterator<T> iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Row next() {
            return SelectTableSinkBase.this.convertToRow(this.iterator.next());
        }

        public void close() throws Exception {
            this.iterator.close();
        }
    }
}

