/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.functions.python.PythonFunctionKind;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamExecPythonGroupAggregate;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.utils.PythonUtil;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class StreamExecPythonGroupAggregateRule
extends ConverterRule {
    public static final RelOptRule INSTANCE = new StreamExecPythonGroupAggregateRule();

    public StreamExecPythonGroupAggregateRule() {
        super(FlinkLogicalAggregate.class, FlinkConventions.LOGICAL(), FlinkConventions.STREAM_PHYSICAL(), "StreamExecPythonGroupAggregateRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalAggregate agg = (FlinkLogicalAggregate)call.rel(0);
        if (agg.getGroupType() != Aggregate.Group.SIMPLE) {
            throw new TableException("GROUPING SETS are currently not supported.");
        }
        agg.getClass();
        List<AggregateCall> aggCalls = agg.getAggCallList();
        boolean existGeneralPythonFunction = aggCalls.stream().anyMatch(x -> PythonUtil.isPythonAggregate(x, PythonFunctionKind.GENERAL));
        boolean existPandasFunction = aggCalls.stream().anyMatch(x -> PythonUtil.isPythonAggregate(x, PythonFunctionKind.PANDAS));
        boolean existJavaUserDefinedFunction = aggCalls.stream().anyMatch(x -> !PythonUtil.isPythonAggregate(x, null) && !PythonUtil.isBuiltInAggregate(x));
        if (existPandasFunction || existGeneralPythonFunction) {
            if (existPandasFunction) {
                throw new TableException("Pandas UDAFs are not supported in streaming mode currently.");
            }
            if (existJavaUserDefinedFunction) {
                throw new TableException("Python UDAF and Java/Scala UDAF cannot be used together.");
            }
            return true;
        }
        return false;
    }

    @Override
    public RelNode convert(RelNode rel) {
        FlinkLogicalAggregate agg = (FlinkLogicalAggregate)rel;
        FlinkRelDistribution requiredDistribution = agg.getGroupCount() != 0 ? FlinkRelDistribution.hash(agg.getGroupSet().asList(), true) : FlinkRelDistribution.SINGLETON();
        RelTraitSet requiredTraitSet = rel.getCluster().getPlanner().emptyTraitSet().replace(requiredDistribution).replace(FlinkConventions.STREAM_PHYSICAL());
        RelTraitSet providedTraitSet = rel.getTraitSet().replace(FlinkConventions.STREAM_PHYSICAL());
        RelNode newInput = RelOptRule.convert(agg.getInput(), requiredTraitSet);
        return new StreamExecPythonGroupAggregate(rel.getCluster(), providedTraitSet, newInput, rel.getRowType(), agg.getGroupSet().toArray(), (Seq<AggregateCall>)((Iterator)JavaConverters.asScalaIteratorConverter(agg.getAggCallList().iterator()).asScala()).toSeq());
    }
}

