/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public class ExecEdge {
    public static final ExecEdge DEFAULT = ExecEdge.builder().build();
    private final RequiredShuffle requiredShuffle;
    private final DamBehavior damBehavior;
    private final int priority;

    private ExecEdge(RequiredShuffle requiredShuffle, DamBehavior damBehavior, int priority) {
        this.requiredShuffle = requiredShuffle;
        this.damBehavior = damBehavior;
        this.priority = priority;
    }

    public RequiredShuffle getRequiredShuffle() {
        return this.requiredShuffle;
    }

    public DamBehavior getDamBehavior() {
        return this.damBehavior;
    }

    public int getPriority() {
        return this.priority;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum DamBehavior {
        PIPELINED,
        END_INPUT,
        BLOCKING;


        public boolean stricterOrEqual(DamBehavior o) {
            return this.ordinal() >= o.ordinal();
        }
    }

    public static enum ShuffleType {
        ANY,
        HASH,
        BROADCAST,
        SINGLETON,
        UNKNOWN;

    }

    public static class RequiredShuffle {
        private final ShuffleType type;
        private final int[] keys;

        private RequiredShuffle(ShuffleType type) {
            this(type, new int[0]);
        }

        private RequiredShuffle(ShuffleType type, int[] keys) {
            this.type = type;
            this.keys = keys;
        }

        public ShuffleType getType() {
            return this.type;
        }

        public int[] getKeys() {
            return this.keys;
        }

        public static RequiredShuffle any() {
            return new RequiredShuffle(ShuffleType.ANY);
        }

        public static RequiredShuffle hash(int[] keys) {
            Preconditions.checkArgument((keys.length > 0 ? 1 : 0) != 0, (Object)"Hash keys must no be empty.");
            return new RequiredShuffle(ShuffleType.HASH, keys);
        }

        public static RequiredShuffle broadcast() {
            return new RequiredShuffle(ShuffleType.BROADCAST);
        }

        public static RequiredShuffle singleton() {
            return new RequiredShuffle(ShuffleType.SINGLETON);
        }

        public static RequiredShuffle unknown() {
            return new RequiredShuffle(ShuffleType.UNKNOWN);
        }
    }

    public static class Builder {
        private RequiredShuffle requiredShuffle = RequiredShuffle.unknown();
        private DamBehavior damBehavior = DamBehavior.PIPELINED;
        private int priority = 0;

        private Builder() {
        }

        public Builder requiredShuffle(RequiredShuffle requiredShuffle) {
            this.requiredShuffle = requiredShuffle;
            return this;
        }

        public Builder damBehavior(DamBehavior damBehavior) {
            this.damBehavior = damBehavior;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public ExecEdge build() {
            return new ExecEdge(this.requiredShuffle, this.damBehavior, this.priority);
        }
    }
}

