/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.Arrays;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.planner.functions.InternalFunctionDefinitions;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.TimestampType;

public abstract class SingleValueAggFunction
extends DeclarativeAggregateFunction {
    private static final long serialVersionUID = 8850662568341069949L;
    private static final Expression ZERO = ExpressionBuilder.literal(0, (DataType)DataTypes.INT().notNull());
    private static final Expression ONE = ExpressionBuilder.literal(1, (DataType)DataTypes.INT().notNull());
    private static final String ERROR_MSG = "SingleValueAggFunction received more than one element.";
    private UnresolvedReferenceExpression value = ApiExpressionUtils.unresolvedRef((String)"value");
    private UnresolvedReferenceExpression count = ApiExpressionUtils.unresolvedRef((String)"count");

    @Override
    public int operandCount() {
        return 1;
    }

    @Override
    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        return new UnresolvedReferenceExpression[]{this.value, this.count};
    }

    @Override
    public DataType[] getAggBufferTypes() {
        return new DataType[]{this.getResultType(), DataTypes.INT()};
    }

    @Override
    public Expression[] initialValuesExpressions() {
        return new Expression[]{ExpressionBuilder.nullOf(this.getResultType()), ZERO};
    }

    @Override
    public Expression[] accumulateExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.greaterThan((Expression)this.count, ZERO), SingleValueAggFunction.throwException(ERROR_MSG, this.getResultType()), (Expression)this.operand(0)), ExpressionBuilder.plus((Expression)this.count, ONE)};
    }

    @Override
    public Expression[] retractExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.or((Expression)ExpressionBuilder.equalTo((Expression)this.count, ONE), (Expression)ExpressionBuilder.equalTo((Expression)this.count, ZERO)), (Expression)ExpressionBuilder.nullOf(this.getResultType()), SingleValueAggFunction.throwException(ERROR_MSG, this.getResultType())), ExpressionBuilder.minus((Expression)this.count, ONE)};
    }

    @Override
    public Expression[] mergeExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.greaterThan((Expression)ExpressionBuilder.plus((Expression)this.count, (Expression)this.mergeOperand(this.count)), ONE), SingleValueAggFunction.throwException(ERROR_MSG, this.getResultType()), (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.equalTo((Expression)ExpressionBuilder.plus((Expression)this.count, (Expression)this.mergeOperand(this.count)), ZERO), (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.or((Expression)ExpressionBuilder.equalTo((Expression)this.count, ZERO), (Expression)ExpressionBuilder.greaterThan((Expression)this.mergeOperand(this.count), ZERO)), (Expression)this.mergeOperand(this.value), (Expression)ExpressionBuilder.nullOf(this.getResultType())), (Expression)this.mergeOperand(this.value))), ExpressionBuilder.plus((Expression)this.count, (Expression)this.mergeOperand(this.count))};
    }

    @Override
    public Expression getValueExpression() {
        return this.value;
    }

    private static Expression throwException(String msg, DataType type) {
        return new CallExpression((FunctionDefinition)InternalFunctionDefinitions.THROW_EXCEPTION, Arrays.asList(ExpressionBuilder.literal(msg), ExpressionBuilder.typeLiteral(type)), type);
    }

    public static final class TimestampSingleValueAggFunction
    extends SingleValueAggFunction {
        private static final long serialVersionUID = 320495723666949978L;
        private final TimestampType type;

        public TimestampSingleValueAggFunction(TimestampType type) {
            this.type = type;
        }

        @Override
        public DataType getResultType() {
            return DataTypes.TIMESTAMP((int)this.type.getPrecision());
        }
    }

    public static final class TimeSingleValueAggFunction
    extends SingleValueAggFunction {
        private static final long serialVersionUID = 320495723666949978L;

        @Override
        public DataType getResultType() {
            return DataTypes.TIME((int)0);
        }
    }

    public static final class DateSingleValueAggFunction
    extends SingleValueAggFunction {
        private static final long serialVersionUID = 320495723666949978L;

        @Override
        public DataType getResultType() {
            return DataTypes.DATE();
        }
    }

    public static final class StringSingleValueAggFunction
    extends SingleValueAggFunction {
        private static final long serialVersionUID = 320495723666949978L;

        @Override
        public DataType getResultType() {
            return DataTypes.STRING();
        }
    }

    public static final class DecimalSingleValueAggFunction
    extends SingleValueAggFunction {
        private static final long serialVersionUID = 320495723666949978L;
        private final DecimalType type;

        public DecimalSingleValueAggFunction(DecimalType type) {
            this.type = type;
        }

        @Override
        public DataType getResultType() {
            return DataTypes.DECIMAL((int)this.type.getPrecision(), (int)this.type.getScale());
        }
    }

    public static final class BooleanSingleValueAggFunction
    extends SingleValueAggFunction {
        private static final long serialVersionUID = 320495723666949978L;

        @Override
        public DataType getResultType() {
            return DataTypes.BOOLEAN();
        }
    }

    public static final class DoubleSingleValueAggFunction
    extends SingleValueAggFunction {
        private static final long serialVersionUID = 320495723666949978L;

        @Override
        public DataType getResultType() {
            return DataTypes.DOUBLE();
        }
    }

    public static final class FloatSingleValueAggFunction
    extends SingleValueAggFunction {
        private static final long serialVersionUID = 320495723666949978L;

        @Override
        public DataType getResultType() {
            return DataTypes.FLOAT();
        }
    }

    public static final class LongSingleValueAggFunction
    extends SingleValueAggFunction {
        private static final long serialVersionUID = 320495723666949978L;

        @Override
        public DataType getResultType() {
            return DataTypes.BIGINT();
        }
    }

    public static final class IntSingleValueAggFunction
    extends SingleValueAggFunction {
        private static final long serialVersionUID = 320495723666949978L;

        @Override
        public DataType getResultType() {
            return DataTypes.INT();
        }
    }

    public static final class ShortSingleValueAggFunction
    extends SingleValueAggFunction {
        private static final long serialVersionUID = 320495723666949978L;

        @Override
        public DataType getResultType() {
            return DataTypes.SMALLINT();
        }
    }

    public static final class ByteSingleValueAggFunction
    extends SingleValueAggFunction {
        private static final long serialVersionUID = 320495723666949978L;

        @Override
        public DataType getResultType() {
            return DataTypes.TINYINT();
        }
    }
}

