/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeComparability;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.ComparableOperandTypeChecker;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.CompositeSingleOperandTypeChecker;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.LiteralOperandTypeChecker;
import org.apache.calcite.sql.type.MultisetOperandTypeChecker;
import org.apache.calcite.sql.type.OperandMetadataImpl;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SameOperandTypeExceptLastOperandChecker;
import org.apache.calcite.sql.type.SetopOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Static;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public abstract class OperandTypes {
    public static final SqlSingleOperandTypeChecker NILADIC = OperandTypes.family(new SqlTypeFamily[0]);
    public static final SqlOperandTypeChecker VARIADIC = OperandTypes.variadic(SqlOperandCountRanges.any());
    public static final SqlOperandTypeChecker ONE_OR_MORE = OperandTypes.variadic(SqlOperandCountRanges.from(1));
    public static final SqlSingleOperandTypeChecker BOOLEAN = OperandTypes.family(SqlTypeFamily.BOOLEAN);
    public static final SqlSingleOperandTypeChecker BOOLEAN_BOOLEAN = OperandTypes.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.BOOLEAN);
    public static final SqlSingleOperandTypeChecker NUMERIC = OperandTypes.family(SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker INTEGER = OperandTypes.family(SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker NUMERIC_OPTIONAL_INTEGER = OperandTypes.family(ImmutableList.of(SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER), (Integer number) -> number == 1);
    public static final SqlSingleOperandTypeChecker NUMERIC_INTEGER = OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker NUMERIC_NUMERIC = OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker EXACT_NUMERIC = OperandTypes.family(SqlTypeFamily.EXACT_NUMERIC);
    public static final SqlSingleOperandTypeChecker EXACT_NUMERIC_EXACT_NUMERIC = OperandTypes.family(SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.EXACT_NUMERIC);
    public static final SqlSingleOperandTypeChecker BINARY = OperandTypes.family(SqlTypeFamily.BINARY);
    public static final SqlSingleOperandTypeChecker STRING = OperandTypes.family(SqlTypeFamily.STRING);
    public static final FamilyOperandTypeChecker STRING_STRING = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING);
    public static final FamilyOperandTypeChecker STRING_STRING_STRING = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING);
    public static final FamilyOperandTypeChecker STRING_STRING_OPTIONAL_STRING = OperandTypes.family(ImmutableList.of(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING), (Integer number) -> number == 2);
    public static final SqlSingleOperandTypeChecker CHARACTER = OperandTypes.family(SqlTypeFamily.CHARACTER);
    public static final SqlSingleOperandTypeChecker DATETIME = OperandTypes.family(SqlTypeFamily.DATETIME);
    public static final SqlSingleOperandTypeChecker DATE = OperandTypes.family(SqlTypeFamily.DATE);
    public static final SqlSingleOperandTypeChecker TIMESTAMP = OperandTypes.family(SqlTypeFamily.TIMESTAMP);
    public static final SqlSingleOperandTypeChecker INTERVAL = OperandTypes.family(SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker CHARACTER_CHARACTER_DATETIME = OperandTypes.family(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.DATETIME);
    public static final SqlSingleOperandTypeChecker PERIOD = new PeriodOperandTypeChecker();
    public static final SqlSingleOperandTypeChecker PERIOD_OR_DATETIME = OperandTypes.or(PERIOD, DATETIME);
    public static final FamilyOperandTypeChecker INTERVAL_INTERVAL = OperandTypes.family(SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker MULTISET = OperandTypes.family(SqlTypeFamily.MULTISET);
    public static final SqlSingleOperandTypeChecker ARRAY = OperandTypes.family(SqlTypeFamily.ARRAY);
    public static final SqlSingleOperandTypeChecker COLLECTION = OperandTypes.or(OperandTypes.family(SqlTypeFamily.MULTISET), OperandTypes.family(SqlTypeFamily.ARRAY));
    public static final SqlSingleOperandTypeChecker COLLECTION_OR_MAP = OperandTypes.or(OperandTypes.family(SqlTypeFamily.MULTISET), OperandTypes.family(SqlTypeFamily.ARRAY), OperandTypes.family(SqlTypeFamily.MAP));
    public static final SqlSingleOperandTypeChecker NULLABLE_LITERAL = new LiteralOperandTypeChecker(true);
    public static final SqlSingleOperandTypeChecker LITERAL = new LiteralOperandTypeChecker(false);
    public static final SqlSingleOperandTypeChecker POSITIVE_INTEGER_LITERAL = new FamilyOperandTypeChecker(ImmutableList.of(SqlTypeFamily.INTEGER), i -> false){

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            if (!LITERAL.checkSingleOperandType(callBinding, node, iFormalOperand, throwOnFailure)) {
                return false;
            }
            if (!super.checkSingleOperandType(callBinding, node, iFormalOperand, throwOnFailure)) {
                return false;
            }
            SqlLiteral arg = (SqlLiteral)node;
            BigDecimal value = (BigDecimal)arg.getValue();
            if (value.compareTo(BigDecimal.ZERO) < 0 || this.hasFractionalPart(value)) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.argumentMustBePositiveInteger(callBinding.getOperator().getName()));
                }
                return false;
            }
            if (value.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) > 0) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.numberLiteralOutOfRange(value.toString()));
                }
                return false;
            }
            return true;
        }

        private boolean hasFractionalPart(BigDecimal bd) {
            return bd.precision() - bd.scale() <= 0;
        }
    };
    public static final SqlSingleOperandTypeChecker SAME_SAME = new SameOperandTypeChecker(2);
    public static final SqlSingleOperandTypeChecker SAME_SAME_INTEGER = new SameOperandTypeExceptLastOperandChecker(3, "INTEGER");
    public static final SqlSingleOperandTypeChecker SAME_SAME_SAME = new SameOperandTypeChecker(3);
    public static final SqlOperandTypeChecker SAME_VARIADIC = new SameOperandTypeChecker(-1);
    public static final SqlOperandTypeChecker COMPARABLE_ORDERED_COMPARABLE_ORDERED = new ComparableOperandTypeChecker(2, RelDataTypeComparability.ALL, SqlOperandTypeChecker.Consistency.COMPARE);
    public static final SqlOperandTypeChecker COMPARABLE_ORDERED = new ComparableOperandTypeChecker(1, RelDataTypeComparability.ALL, SqlOperandTypeChecker.Consistency.NONE);
    public static final SqlOperandTypeChecker COMPARABLE_UNORDERED_COMPARABLE_UNORDERED = new ComparableOperandTypeChecker(2, RelDataTypeComparability.UNORDERED, SqlOperandTypeChecker.Consistency.LEAST_RESTRICTIVE);
    public static final SqlSingleOperandTypeChecker STRING_SAME_SAME = OperandTypes.and(STRING_STRING, SAME_SAME);
    public static final SqlSingleOperandTypeChecker STRING_SAME_SAME_SAME = OperandTypes.and(STRING_STRING_STRING, SAME_SAME_SAME);
    public static final SqlSingleOperandTypeChecker STRING_STRING_INTEGER = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker STRING_STRING_INTEGER_INTEGER = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker STRING_INTEGER = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker CBSTRING_INTEGER = OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.BINARY, SqlTypeFamily.INTEGER));
    public static final SqlSingleOperandTypeChecker STRING_SAME_SAME_INTEGER = OperandTypes.and(STRING_STRING_INTEGER, SAME_SAME_INTEGER);
    public static final SqlSingleOperandTypeChecker ANY = OperandTypes.family(SqlTypeFamily.ANY);
    public static final SqlSingleOperandTypeChecker ANY_ANY = OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.ANY);
    public static final SqlSingleOperandTypeChecker ANY_IGNORE = OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.IGNORE);
    public static final SqlSingleOperandTypeChecker IGNORE_ANY = OperandTypes.family(SqlTypeFamily.IGNORE, SqlTypeFamily.ANY);
    public static final SqlSingleOperandTypeChecker ANY_NUMERIC = OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker CURSOR = OperandTypes.family(SqlTypeFamily.CURSOR);
    public static final SqlSingleOperandTypeChecker INTERVAL_SAME_SAME = OperandTypes.and(INTERVAL_INTERVAL, SAME_SAME);
    public static final SqlSingleOperandTypeChecker NUMERIC_INTERVAL = OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker INTERVAL_NUMERIC = OperandTypes.family(SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker DATETIME_INTERVAL = OperandTypes.family(SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker DATETIME_INTERVAL_INTERVAL = OperandTypes.family(SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker DATETIME_INTERVAL_INTERVAL_TIME = OperandTypes.family(SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.TIME);
    public static final SqlSingleOperandTypeChecker DATETIME_INTERVAL_TIME = OperandTypes.family(SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.TIME);
    public static final SqlSingleOperandTypeChecker INTERVAL_DATETIME = OperandTypes.family(SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.DATETIME);
    public static final SqlSingleOperandTypeChecker INTERVALINTERVAL_INTERVALDATETIME = OperandTypes.or(INTERVAL_SAME_SAME, INTERVAL_DATETIME);
    public static final SqlSingleOperandTypeChecker PLUS_OPERATOR = OperandTypes.or(NUMERIC_NUMERIC, INTERVAL_SAME_SAME, DATETIME_INTERVAL, INTERVAL_DATETIME);
    public static final SqlSingleOperandTypeChecker MULTIPLY_OPERATOR = OperandTypes.or(NUMERIC_NUMERIC, INTERVAL_NUMERIC, NUMERIC_INTERVAL);
    public static final SqlSingleOperandTypeChecker DIVISION_OPERATOR = OperandTypes.or(NUMERIC_NUMERIC, INTERVAL_NUMERIC);
    public static final SqlSingleOperandTypeChecker MINUS_OPERATOR = OperandTypes.or(NUMERIC_NUMERIC, INTERVAL_SAME_SAME, DATETIME_INTERVAL);
    public static final FamilyOperandTypeChecker MINUS_DATE_OPERATOR = new FamilyOperandTypeChecker(ImmutableList.of(SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME_INTERVAL), i -> false){

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            if (!super.checkOperandTypes(callBinding, throwOnFailure)) {
                return false;
            }
            return SAME_SAME.checkOperandTypes(callBinding, throwOnFailure);
        }
    };
    public static final SqlSingleOperandTypeChecker NUMERIC_OR_INTERVAL = OperandTypes.or(NUMERIC, INTERVAL);
    public static final SqlSingleOperandTypeChecker NUMERIC_OR_STRING = OperandTypes.or(NUMERIC, STRING);
    public static final SqlSingleOperandTypeChecker RECORD_COLLECTION = new RecordTypeWithOneFieldChecker(sqlTypeName -> sqlTypeName != SqlTypeName.ARRAY && sqlTypeName != SqlTypeName.MULTISET){

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return "UNNEST(<MULTISET>)";
        }
    };
    public static final SqlSingleOperandTypeChecker SCALAR_OR_RECORD_COLLECTION = OperandTypes.or(COLLECTION, RECORD_COLLECTION);
    public static final SqlSingleOperandTypeChecker SCALAR_OR_RECORD_COLLECTION_OR_MAP = OperandTypes.or(COLLECTION_OR_MAP, new RecordTypeWithOneFieldChecker(sqlTypeName -> sqlTypeName != SqlTypeName.MULTISET && sqlTypeName != SqlTypeName.ARRAY && sqlTypeName != SqlTypeName.MAP){

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return "UNNEST(<MULTISET>)\nUNNEST(<ARRAY>)\nUNNEST(<MAP>)";
        }
    });
    public static final SqlOperandTypeChecker MULTISET_MULTISET = new MultisetOperandTypeChecker();
    public static final SqlOperandTypeChecker SET_OP = new SetopOperandTypeChecker();
    public static final SqlOperandTypeChecker RECORD_TO_SCALAR = new SqlSingleOperandTypeChecker(){

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            assert (0 == iFormalOperand);
            RelDataType type = SqlTypeUtil.deriveType(callBinding, node);
            boolean validationError = false;
            if (!type.isStruct()) {
                validationError = true;
            } else if (type.getFieldList().size() != 1) {
                validationError = true;
            }
            if (validationError && throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return !validationError;
        }

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            return this.checkSingleOperandType(callBinding, callBinding.operand(0), 0, throwOnFailure);
        }

        @Override
        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.of(1);
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return SqlUtil.getAliasedSignature(op, opName, ImmutableList.of("RECORDTYPE(SINGLE FIELD)"));
        }

        @Override
        public boolean isOptional(int i) {
            return false;
        }

        @Override
        public SqlOperandTypeChecker.Consistency getConsistency() {
            return SqlOperandTypeChecker.Consistency.NONE;
        }
    };

    private OperandTypes() {
    }

    public static FamilyOperandTypeChecker family(SqlTypeFamily ... families) {
        return new FamilyOperandTypeChecker(ImmutableList.copyOf(families), i -> false);
    }

    public static FamilyOperandTypeChecker family(List<SqlTypeFamily> families, Predicate<Integer> optional) {
        return new FamilyOperandTypeChecker(families, optional);
    }

    public static FamilyOperandTypeChecker family(List<SqlTypeFamily> families) {
        return OperandTypes.family(families, (Integer i) -> false);
    }

    public static SqlOperandMetadata operandMetadata(List<SqlTypeFamily> families, Function<RelDataTypeFactory, List<RelDataType>> typesFactory, IntFunction<String> operandName, Predicate<Integer> optional) {
        return new OperandMetadataImpl(families, typesFactory, operandName, optional);
    }

    public static SqlOperandTypeChecker or(SqlOperandTypeChecker ... rules) {
        return new CompositeOperandTypeChecker(CompositeOperandTypeChecker.Composition.OR, ImmutableList.copyOf(rules), null, null);
    }

    public static SqlOperandTypeChecker and(SqlOperandTypeChecker ... rules) {
        return new CompositeOperandTypeChecker(CompositeOperandTypeChecker.Composition.AND, ImmutableList.copyOf(rules), null, null);
    }

    public static SqlSingleOperandTypeChecker or(SqlSingleOperandTypeChecker ... rules) {
        return new CompositeSingleOperandTypeChecker(CompositeOperandTypeChecker.Composition.OR, ImmutableList.copyOf(rules), null);
    }

    public static SqlSingleOperandTypeChecker and(SqlSingleOperandTypeChecker ... rules) {
        return new CompositeSingleOperandTypeChecker(CompositeOperandTypeChecker.Composition.AND, ImmutableList.copyOf(rules), null);
    }

    public static SqlOperandTypeChecker sequence(String allowedSignatures, SqlSingleOperandTypeChecker ... rules) {
        return new CompositeOperandTypeChecker(CompositeOperandTypeChecker.Composition.SEQUENCE, ImmutableList.copyOf(rules), allowedSignatures, null);
    }

    public static SqlOperandTypeChecker repeat(SqlOperandCountRange range2, SqlSingleOperandTypeChecker ... rules) {
        return new CompositeOperandTypeChecker(CompositeOperandTypeChecker.Composition.REPEAT, ImmutableList.copyOf(rules), null, range2);
    }

    public static SqlOperandTypeChecker variadic(final SqlOperandCountRange range2) {
        return new SqlOperandTypeChecker(){

            @Override
            public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
                return range2.isValidCount(callBinding.getOperandCount());
            }

            @Override
            public SqlOperandCountRange getOperandCountRange() {
                return range2;
            }

            @Override
            public String getAllowedSignatures(SqlOperator op, String opName) {
                return opName + "(...)";
            }

            @Override
            public boolean isOptional(int i) {
                return false;
            }

            @Override
            public SqlOperandTypeChecker.Consistency getConsistency() {
                return SqlOperandTypeChecker.Consistency.NONE;
            }
        };
    }

    private static class PeriodOperandTypeChecker
    implements SqlSingleOperandTypeChecker {
        private PeriodOperandTypeChecker() {
        }

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            assert (0 == iFormalOperand);
            RelDataType type = SqlTypeUtil.deriveType(callBinding, node);
            boolean valid = false;
            if (type.isStruct() && type.getFieldList().size() == 2) {
                RelDataType t0 = type.getFieldList().get(0).getType();
                RelDataType t1 = type.getFieldList().get(1).getType();
                if (SqlTypeUtil.isDatetime(t0)) {
                    if (SqlTypeUtil.isDatetime(t1)) {
                        if (SqlTypeUtil.sameNamedType(t0, t1)) {
                            valid = true;
                        }
                    } else if (SqlTypeUtil.isInterval(t1)) {
                        valid = true;
                    }
                }
            }
            if (!valid && throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return valid;
        }

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            return this.checkSingleOperandType(callBinding, callBinding.operand(0), 0, throwOnFailure);
        }

        @Override
        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.of(1);
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return SqlUtil.getAliasedSignature(op, opName, ImmutableList.of("PERIOD (DATETIME, INTERVAL)", "PERIOD (DATETIME, DATETIME)"));
        }

        @Override
        public boolean isOptional(int i) {
            return false;
        }

        @Override
        public SqlOperandTypeChecker.Consistency getConsistency() {
            return SqlOperandTypeChecker.Consistency.NONE;
        }
    }

    private static abstract class RecordTypeWithOneFieldChecker
    implements SqlSingleOperandTypeChecker {
        private final Predicate<SqlTypeName> typeNamePredicate;

        private RecordTypeWithOneFieldChecker(Predicate<SqlTypeName> predicate) {
            this.typeNamePredicate = predicate;
        }

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            assert (0 == iFormalOperand);
            RelDataType type = SqlTypeUtil.deriveType(callBinding, node);
            boolean validationError = false;
            if (!type.isStruct()) {
                validationError = true;
            } else if (type.getFieldList().size() != 1) {
                validationError = true;
            } else {
                SqlTypeName typeName = type.getFieldList().get(0).getType().getSqlTypeName();
                if (this.typeNamePredicate.test(typeName)) {
                    validationError = true;
                }
            }
            if (validationError && throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return !validationError;
        }

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            return this.checkSingleOperandType(callBinding, callBinding.operand(0), 0, throwOnFailure);
        }

        @Override
        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.of(1);
        }

        @Override
        public boolean isOptional(int i) {
            return false;
        }

        @Override
        public SqlOperandTypeChecker.Consistency getConsistency() {
            return SqlOperandTypeChecker.Consistency.NONE;
        }
    }
}

