/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.SetQueryOperation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
final class SetOperationFactory {
    private final boolean isStreamingMode;

    public SetOperationFactory(boolean isStreamingMode) {
        this.isStreamingMode = isStreamingMode;
    }

    QueryOperation create(SetQueryOperation.SetQueryOperationType type, QueryOperation left, QueryOperation right, boolean all) {
        this.failIfStreaming(type, all);
        this.validateSetOperation(type, left, right);
        return new SetQueryOperation(left, right, type, all, this.createCommonTableSchema(left, right));
    }

    private void validateSetOperation(SetQueryOperation.SetQueryOperationType operationType, QueryOperation left, QueryOperation right) {
        TableSchema rightSchema;
        int rightFieldCount;
        TableSchema leftSchema = left.getTableSchema();
        int leftFieldCount = leftSchema.getFieldCount();
        if (leftFieldCount != (rightFieldCount = (rightSchema = right.getTableSchema()).getFieldCount())) {
            throw new ValidationException(String.format("The %s operation on two tables of different column sizes: %d and %d is not supported", operationType.toString().toLowerCase(), leftFieldCount, rightFieldCount));
        }
        DataType[] leftDataTypes = leftSchema.getFieldDataTypes();
        DataType[] rightDataTypes = rightSchema.getFieldDataTypes();
        IntStream.range(0, leftFieldCount).forEach(idx -> {
            if (!this.findCommonColumnType(leftDataTypes, rightDataTypes, idx).isPresent()) {
                throw new ValidationException(String.format("Incompatible types for %s operation. Could not find a common type at position %s for '%s' and '%s'.", operationType.toString().toLowerCase(), idx, leftDataTypes[idx], rightDataTypes[idx]));
            }
        });
    }

    private void failIfStreaming(SetQueryOperation.SetQueryOperationType type, boolean all) {
        boolean shouldFailInCaseOfStreaming;
        boolean bl = shouldFailInCaseOfStreaming = !all || type != SetQueryOperation.SetQueryOperationType.UNION;
        if (this.isStreamingMode && shouldFailInCaseOfStreaming) {
            throw new ValidationException(String.format("The %s operation on two unbounded tables is currently not supported.", new Object[]{type}));
        }
    }

    private TableSchema createCommonTableSchema(QueryOperation left, QueryOperation right) {
        TableSchema leftSchema = left.getTableSchema();
        DataType[] leftDataTypes = leftSchema.getFieldDataTypes();
        DataType[] rightDataTypes = right.getTableSchema().getFieldDataTypes();
        DataType[] resultDataTypes = (DataType[])IntStream.range(0, leftSchema.getFieldCount()).mapToObj(idx -> this.findCommonColumnType(leftDataTypes, rightDataTypes, idx).orElseThrow(AssertionError::new)).map(TypeConversions::fromLogicalToDataType).toArray(DataType[]::new);
        return TableSchema.builder().fields(leftSchema.getFieldNames(), resultDataTypes).build();
    }

    private Optional<LogicalType> findCommonColumnType(DataType[] leftDataTypes, DataType[] rightDataTypes, int idx) {
        LogicalType leftType = leftDataTypes[idx].getLogicalType();
        LogicalType rightType = rightDataTypes[idx].getLogicalType();
        return LogicalTypeMerging.findCommonType(Arrays.asList(leftType, rightType));
    }
}

