/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.translators;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.graph.SimpleTransformationTranslator;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.transformations.LegacySinkTransformation;
import org.apache.flink.streaming.runtime.translators.BatchExecutionUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class LegacySinkTransformationTranslator<IN>
extends SimpleTransformationTranslator<Object, LegacySinkTransformation<IN>> {
    @Override
    protected Collection<Integer> translateForBatchInternal(LegacySinkTransformation<IN> transformation, TransformationTranslator.Context context) {
        boolean isKeyed;
        Collection<Integer> ids = this.translateInternal(transformation, context);
        boolean bl = isKeyed = transformation.getStateKeySelector() != null;
        if (isKeyed) {
            BatchExecutionUtils.applyBatchExecutionSettings(transformation.getId(), context, StreamConfig.InputRequirement.SORTED);
        }
        return ids;
    }

    @Override
    protected Collection<Integer> translateForStreamingInternal(LegacySinkTransformation<IN> transformation, TransformationTranslator.Context context) {
        return this.translateInternal(transformation, context);
    }

    private Collection<Integer> translateInternal(LegacySinkTransformation<IN> transformation, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull((Object)context);
        StreamGraph streamGraph = context.getStreamGraph();
        String slotSharingGroup = context.getSlotSharingGroup();
        int transformationId = transformation.getId();
        ExecutionConfig executionConfig = streamGraph.getExecutionConfig();
        List<Transformation<?>> parentTransformations = transformation.getInputs();
        Preconditions.checkState((parentTransformations.size() == 1 ? 1 : 0) != 0, (Object)("Expected exactly one input transformation but found " + parentTransformations.size()));
        Transformation<?> input = parentTransformations.get(0);
        streamGraph.addSink(transformationId, slotSharingGroup, transformation.getCoLocationGroupKey(), transformation.getOperatorFactory(), input.getOutputType(), null, "Sink: " + transformation.getName());
        int parallelism = transformation.getParallelism() != -1 ? transformation.getParallelism() : executionConfig.getParallelism();
        streamGraph.setParallelism(transformationId, parallelism);
        streamGraph.setMaxParallelism(transformationId, transformation.getMaxParallelism());
        for (Integer inputId : context.getStreamNodeIds(input)) {
            streamGraph.addEdge(inputId, transformationId, 0);
        }
        if (transformation.getStateKeySelector() != null) {
            TypeSerializer keySerializer = transformation.getStateKeyType().createSerializer(executionConfig);
            streamGraph.setOneInputStateKey(transformationId, transformation.getStateKeySelector(), keySerializer);
        }
        return Collections.emptyList();
    }
}

