/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;

final class BatchGlobalCommitterOperator<CommT, GlobalCommT>
extends AbstractStreamOperator<GlobalCommT>
implements OneInputStreamOperator<CommT, GlobalCommT>,
BoundedOneInput {
    private final GlobalCommitter<CommT, GlobalCommT> globalCommitter;
    private final List<CommT> allCommittables;

    BatchGlobalCommitterOperator(GlobalCommitter<CommT, GlobalCommT> globalCommitter) {
        this.globalCommitter = (GlobalCommitter)Preconditions.checkNotNull(globalCommitter);
        this.allCommittables = new ArrayList<CommT>();
    }

    @Override
    public void processElement(StreamRecord<CommT> element) {
        this.allCommittables.add(element.getValue());
    }

    @Override
    public void endInput() throws Exception {
        Object globalCommittable;
        List neededRetryCommittables;
        if (!this.allCommittables.isEmpty() && !(neededRetryCommittables = this.globalCommitter.commit(Collections.singletonList(globalCommittable = this.globalCommitter.combine(this.allCommittables)))).isEmpty()) {
            throw new UnsupportedOperationException("Currently does not support the re-commit!");
        }
        this.globalCommitter.endOfInput();
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.globalCommitter.close();
    }
}

