/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import java.util.Random;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.io.network.api.writer.SubtaskStateMapper;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class ShufflePartitioner<T>
extends StreamPartitioner<T> {
    private static final long serialVersionUID = 1L;
    private Random random = new Random();

    public int selectChannel(SerializationDelegate<StreamRecord<T>> record) {
        return this.random.nextInt(this.numberOfChannels);
    }

    @Override
    public SubtaskStateMapper getDownstreamSubtaskStateMapper() {
        return SubtaskStateMapper.ROUND_ROBIN;
    }

    @Override
    public StreamPartitioner<T> copy() {
        return new ShufflePartitioner<T>();
    }

    public String toString() {
        return "SHUFFLE";
    }
}

