/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.PullingAsyncDataInput;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.EventAnnouncement;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.EndOfChannelStateEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.streaming.api.operators.MailboxExecutor;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.UpstreamRecoveryTracker;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class CheckpointedInputGate
implements PullingAsyncDataInput<BufferOrEvent>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointedInputGate.class);
    private final CheckpointBarrierHandler barrierHandler;
    private final UpstreamRecoveryTracker upstreamRecoveryTracker;
    private final InputGate inputGate;
    private final MailboxExecutor mailboxExecutor;
    private boolean isFinished;

    public CheckpointedInputGate(InputGate inputGate, CheckpointBarrierHandler barrierHandler, MailboxExecutor mailboxExecutor) {
        this(inputGate, barrierHandler, mailboxExecutor, UpstreamRecoveryTracker.NO_OP);
    }

    public CheckpointedInputGate(InputGate inputGate, CheckpointBarrierHandler barrierHandler, MailboxExecutor mailboxExecutor, UpstreamRecoveryTracker upstreamRecoveryTracker) {
        this.inputGate = inputGate;
        this.barrierHandler = barrierHandler;
        this.mailboxExecutor = mailboxExecutor;
        this.upstreamRecoveryTracker = upstreamRecoveryTracker;
        this.waitForPriorityEvents(inputGate, mailboxExecutor);
    }

    private void processPriorityEvents() throws IOException, InterruptedException {
        Optional<BufferOrEvent> bufferOrEventOpt;
        boolean hasPriorityEvent = this.inputGate.getPriorityEventAvailableFuture().isDone();
        while (hasPriorityEvent && (bufferOrEventOpt = this.pollNext()).isPresent()) {
            BufferOrEvent bufferOrEvent = bufferOrEventOpt.get();
            Preconditions.checkState((boolean)bufferOrEvent.hasPriority(), (Object)"Should only poll priority events");
            hasPriorityEvent = bufferOrEvent.morePriorityEvents();
        }
        this.waitForPriorityEvents(this.inputGate, this.mailboxExecutor);
    }

    private void waitForPriorityEvents(InputGate inputGate, MailboxExecutor mailboxExecutor) {
        CompletableFuture priorityEventAvailableFuture = inputGate.getPriorityEventAvailableFuture();
        FutureUtils.assertNoException((CompletableFuture)priorityEventAvailableFuture.thenRun(() -> {
            try {
                mailboxExecutor.execute((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)this::processPriorityEvents), "process priority event @ gate %s", inputGate);
            }
            catch (RejectedExecutionException ex) {
                LOG.debug("Ignored RejectedExecutionException in CheckpointedInputGate.waitForPriorityEvents");
            }
        }));
    }

    public CompletableFuture<?> getAvailableFuture() {
        return this.inputGate.getAvailableFuture();
    }

    public Optional<BufferOrEvent> pollNext() throws IOException, InterruptedException {
        Optional next = this.inputGate.pollNext();
        if (!next.isPresent()) {
            return this.handleEmptyBuffer();
        }
        BufferOrEvent bufferOrEvent = (BufferOrEvent)next.get();
        if (bufferOrEvent.isEvent()) {
            return this.handleEvent(bufferOrEvent);
        }
        if (bufferOrEvent.isBuffer()) {
            this.barrierHandler.addProcessedBytes(bufferOrEvent.getBuffer().getSize());
        }
        return next;
    }

    private Optional<BufferOrEvent> handleEvent(BufferOrEvent bufferOrEvent) throws IOException, InterruptedException {
        Class<?> eventClass = bufferOrEvent.getEvent().getClass();
        if (eventClass == CheckpointBarrier.class) {
            CheckpointBarrier checkpointBarrier = (CheckpointBarrier)bufferOrEvent.getEvent();
            this.barrierHandler.processBarrier(checkpointBarrier, bufferOrEvent.getChannelInfo());
        } else if (eventClass == CancelCheckpointMarker.class) {
            this.barrierHandler.processCancellationBarrier((CancelCheckpointMarker)bufferOrEvent.getEvent());
        } else if (eventClass == EndOfPartitionEvent.class) {
            this.barrierHandler.processEndOfPartition();
        } else if (eventClass == EventAnnouncement.class) {
            EventAnnouncement eventAnnouncement = (EventAnnouncement)bufferOrEvent.getEvent();
            AbstractEvent announcedEvent = eventAnnouncement.getAnnouncedEvent();
            Preconditions.checkState((boolean)(announcedEvent instanceof CheckpointBarrier), (String)"Only CheckpointBarrier announcement are currently supported, but found [%s]", (Object[])new Object[]{announcedEvent});
            CheckpointBarrier announcedBarrier = (CheckpointBarrier)announcedEvent;
            this.barrierHandler.processBarrierAnnouncement(announcedBarrier, eventAnnouncement.getSequenceNumber(), bufferOrEvent.getChannelInfo());
        } else if (bufferOrEvent.getEvent().getClass() == EndOfChannelStateEvent.class) {
            this.upstreamRecoveryTracker.handleEndOfRecovery(bufferOrEvent.getChannelInfo());
            if (!this.upstreamRecoveryTracker.allChannelsRecovered()) {
                return this.pollNext();
            }
        }
        return Optional.of(bufferOrEvent);
    }

    public CompletableFuture<Void> getAllBarriersReceivedFuture(long checkpointId) {
        return this.barrierHandler.getAllBarriersReceivedFuture(checkpointId);
    }

    private Optional<BufferOrEvent> handleEmptyBuffer() {
        if (this.inputGate.isFinished()) {
            this.isFinished = true;
        }
        return Optional.empty();
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void close() throws IOException {
        this.barrierHandler.close();
    }

    @VisibleForTesting
    long getLatestCheckpointId() {
        return this.barrierHandler.getLatestCheckpointId();
    }

    @VisibleForTesting
    long getAlignmentDurationNanos() {
        return this.barrierHandler.getAlignmentDurationNanos();
    }

    @VisibleForTesting
    long getCheckpointStartDelayNanos() {
        return this.barrierHandler.getCheckpointStartDelayNanos();
    }

    public int getNumberOfInputChannels() {
        return this.inputGate.getNumberOfInputChannels();
    }

    public String toString() {
        return this.barrierHandler.toString();
    }

    public InputChannel getChannel(int channelIndex) {
        return this.inputGate.getChannel(channelIndex);
    }

    public List<InputChannelInfo> getChannelInfos() {
        return this.inputGate.getChannelInfos();
    }

    @VisibleForTesting
    CheckpointBarrierHandler getCheckpointBarrierHandler() {
        return this.barrierHandler;
    }
}

