/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.io.StreamTwoInputProcessor;
import org.apache.flink.streaming.runtime.tasks.StreamTask;

@Internal
public class TwoInputStreamTask<IN1, IN2, OUT>
extends StreamTask<OUT, TwoInputStreamOperator<IN1, IN2, OUT>> {
    private StreamTwoInputProcessor<IN1, IN2> inputProcessor;
    private volatile boolean running = true;

    @Override
    public void init() throws Exception {
        StreamConfig configuration = this.getConfiguration();
        ClassLoader userClassLoader = this.getUserCodeClassLoader();
        TypeSerializer inputDeserializer1 = configuration.getTypeSerializerIn1(userClassLoader);
        TypeSerializer inputDeserializer2 = configuration.getTypeSerializerIn2(userClassLoader);
        int numberOfInputs = configuration.getNumberOfInputs();
        ArrayList<InputGate> inputList1 = new ArrayList<InputGate>();
        ArrayList<InputGate> inputList2 = new ArrayList<InputGate>();
        List<StreamEdge> inEdges = configuration.getInPhysicalEdges(userClassLoader);
        block4: for (int i = 0; i < numberOfInputs; ++i) {
            int inputType = inEdges.get(i).getTypeNumber();
            InputGate reader = this.getEnvironment().getInputGate(i);
            switch (inputType) {
                case 1: {
                    inputList1.add(reader);
                    continue block4;
                }
                case 2: {
                    inputList2.add(reader);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Invalid input type number: " + inputType);
                }
            }
        }
        this.inputProcessor = new StreamTwoInputProcessor(inputList1, inputList2, inputDeserializer1, inputDeserializer2, this, configuration.getCheckpointMode(), this.getEnvironment().getIOManager(), this.getEnvironment().getTaskManagerInfo().getConfiguration());
        this.inputProcessor.setMetricGroup(this.getEnvironment().getMetricGroup().getIOMetricGroup());
    }

    @Override
    protected void run() throws Exception {
        TwoInputStreamOperator operator = (TwoInputStreamOperator)this.headOperator;
        StreamTwoInputProcessor<IN1, IN2> inputProcessor = this.inputProcessor;
        Object lock = this.getCheckpointLock();
        while (this.running && inputProcessor.processInput(operator, lock)) {
        }
    }

    @Override
    protected void cleanup() throws Exception {
        if (this.inputProcessor != null) {
            this.inputProcessor.cleanup();
        }
    }

    @Override
    protected void cancelTask() {
        this.running = false;
    }
}

