/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.Collection;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.state.ChainedStateHandle;
import org.apache.flink.runtime.state.KeyGroupsStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.TaskStateHandles;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

@Internal
@VisibleForTesting
public class OperatorStateHandles {
    private final int operatorChainIndex;
    private final StreamStateHandle legacyOperatorState;
    private final Collection<KeyGroupsStateHandle> managedKeyedState;
    private final Collection<KeyGroupsStateHandle> rawKeyedState;
    private final Collection<OperatorStateHandle> managedOperatorState;
    private final Collection<OperatorStateHandle> rawOperatorState;

    public OperatorStateHandles(int operatorChainIndex, StreamStateHandle legacyOperatorState, Collection<KeyGroupsStateHandle> managedKeyedState, Collection<KeyGroupsStateHandle> rawKeyedState, Collection<OperatorStateHandle> managedOperatorState, Collection<OperatorStateHandle> rawOperatorState) {
        this.operatorChainIndex = operatorChainIndex;
        this.legacyOperatorState = legacyOperatorState;
        this.managedKeyedState = managedKeyedState;
        this.rawKeyedState = rawKeyedState;
        this.managedOperatorState = managedOperatorState;
        this.rawOperatorState = rawOperatorState;
    }

    public OperatorStateHandles(TaskStateHandles taskStateHandles, int operatorChainIndex) {
        Preconditions.checkNotNull((Object)taskStateHandles);
        this.operatorChainIndex = operatorChainIndex;
        ChainedStateHandle legacyState = taskStateHandles.getLegacyOperatorState();
        this.legacyOperatorState = ChainedStateHandle.isNullOrEmpty((ChainedStateHandle)legacyState) ? null : (StreamStateHandle)legacyState.get(operatorChainIndex);
        this.rawKeyedState = taskStateHandles.getRawKeyedState();
        this.managedKeyedState = taskStateHandles.getManagedKeyedState();
        this.managedOperatorState = (Collection)OperatorStateHandles.getSafeItemAtIndexOrNull(taskStateHandles.getManagedOperatorState(), operatorChainIndex);
        this.rawOperatorState = (Collection)OperatorStateHandles.getSafeItemAtIndexOrNull(taskStateHandles.getRawOperatorState(), operatorChainIndex);
    }

    public StreamStateHandle getLegacyOperatorState() {
        return this.legacyOperatorState;
    }

    public Collection<KeyGroupsStateHandle> getManagedKeyedState() {
        return this.managedKeyedState;
    }

    public Collection<KeyGroupsStateHandle> getRawKeyedState() {
        return this.rawKeyedState;
    }

    public Collection<OperatorStateHandle> getManagedOperatorState() {
        return this.managedOperatorState;
    }

    public Collection<OperatorStateHandle> getRawOperatorState() {
        return this.rawOperatorState;
    }

    public int getOperatorChainIndex() {
        return this.operatorChainIndex;
    }

    private static <T> T getSafeItemAtIndexOrNull(List<T> list, int idx) {
        return CollectionUtil.isNullOrEmpty(list) ? null : (T)list.get(idx);
    }
}

