/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.metrics.groups.OperatorMetricGroup;
import org.apache.flink.streaming.api.collector.selector.CopyingDirectedOutput;
import org.apache.flink.streaming.api.collector.selector.DirectedOutput;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.RecordWriterOutput;
import org.apache.flink.streaming.runtime.io.StreamRecordWriter;
import org.apache.flink.streaming.runtime.partitioner.ConfigurableStreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ExceptionInChainedOperatorException;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.XORShiftRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class OperatorChain<OUT, OP extends StreamOperator<OUT>> {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorChain.class);
    private final StreamOperator<?>[] allOperators;
    private final RecordWriterOutput<?>[] streamOutputs;
    private final Output<StreamRecord<OUT>> chainEntryPoint;
    private final OP headOperator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperatorChain(StreamTask<OUT, OP> containingTask) {
        ClassLoader userCodeClassloader = containingTask.getUserCodeClassLoader();
        StreamConfig configuration = containingTask.getConfiguration();
        this.headOperator = (StreamOperator)configuration.getStreamOperator(userCodeClassloader);
        Map<Integer, StreamConfig> chainedConfigs = configuration.getTransitiveChainedTaskConfigs(userCodeClassloader);
        chainedConfigs.put(configuration.getVertexID(), configuration);
        List<StreamEdge> outEdgesInOrder = configuration.getOutEdgesInOrder(userCodeClassloader);
        HashMap streamOutputMap = new HashMap(outEdgesInOrder.size());
        this.streamOutputs = new RecordWriterOutput[outEdgesInOrder.size()];
        boolean success = false;
        try {
            for (int i = 0; i < outEdgesInOrder.size(); ++i) {
                StreamEdge outEdge = outEdgesInOrder.get(i);
                RecordWriterOutput streamOutput = OperatorChain.createStreamOutput(outEdge, chainedConfigs.get(outEdge.getSourceId()), i, containingTask.getEnvironment(), containingTask.getName());
                this.streamOutputs[i] = streamOutput;
                streamOutputMap.put(outEdge, streamOutput);
            }
            ArrayList allOps = new ArrayList(chainedConfigs.size());
            this.chainEntryPoint = OperatorChain.createOutputCollector(containingTask, configuration, chainedConfigs, userCodeClassloader, streamOutputMap, allOps);
            if (this.headOperator != null) {
                this.headOperator.setup(containingTask, configuration, this.getChainEntryPoint());
            }
            allOps.add((StreamOperator<?>)this.headOperator);
            this.allOperators = allOps.toArray(new StreamOperator[allOps.size()]);
            success = true;
        }
        finally {
            if (!success) {
                for (RecordWriterOutput<?> output : this.streamOutputs) {
                    if (output == null) continue;
                    output.close();
                    output.clearBuffers();
                }
            }
        }
    }

    public void broadcastCheckpointBarrier(long id, long timestamp) throws IOException {
        try {
            CheckpointBarrier barrier = new CheckpointBarrier(id, timestamp);
            for (RecordWriterOutput<?> streamOutput : this.streamOutputs) {
                streamOutput.broadcastEvent((AbstractEvent)barrier);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while broadcasting checkpoint barrier");
        }
    }

    public void broadcastCheckpointCancelMarker(long id) throws IOException {
        try {
            CancelCheckpointMarker barrier = new CancelCheckpointMarker(id);
            for (RecordWriterOutput<?> streamOutput : this.streamOutputs) {
                streamOutput.broadcastEvent((AbstractEvent)barrier);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while broadcasting checkpoint cancellation");
        }
    }

    public RecordWriterOutput<?>[] getStreamOutputs() {
        return this.streamOutputs;
    }

    public StreamOperator<?>[] getAllOperators() {
        return this.allOperators;
    }

    public Output<StreamRecord<OUT>> getChainEntryPoint() {
        return this.chainEntryPoint;
    }

    public void flushOutputs() throws IOException {
        for (RecordWriterOutput<?> streamOutput : this.getStreamOutputs()) {
            streamOutput.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseOutputs() {
        try {
            for (RecordWriterOutput<?> streamOutput : this.streamOutputs) {
                streamOutput.close();
            }
        }
        finally {
            for (RecordWriterOutput<?> output : this.streamOutputs) {
                output.clearBuffers();
            }
        }
    }

    public OP getHeadOperator() {
        return this.headOperator;
    }

    public int getChainLength() {
        return this.allOperators == null ? 0 : this.allOperators.length;
    }

    private static <T> Output<StreamRecord<T>> createOutputCollector(StreamTask<?, ?> containingTask, StreamConfig operatorConfig, Map<Integer, StreamConfig> chainedConfigs, ClassLoader userCodeClassloader, Map<StreamEdge, RecordWriterOutput<?>> streamOutputs, List<StreamOperator<?>> allOperators) {
        ArrayList allOutputs = new ArrayList(4);
        for (StreamEdge outputEdge : operatorConfig.getNonChainedOutputs(userCodeClassloader)) {
            RecordWriterOutput<?> output = streamOutputs.get(outputEdge);
            allOutputs.add(new Tuple2(output, (Object)outputEdge));
        }
        for (StreamEdge outputEdge : operatorConfig.getChainedOutputs(userCodeClassloader)) {
            int outputId = outputEdge.getTargetId();
            StreamConfig chainedOpConfig = chainedConfigs.get(outputId);
            Output output = OperatorChain.createChainedOperator(containingTask, chainedOpConfig, chainedConfigs, userCodeClassloader, streamOutputs, allOperators);
            allOutputs.add(new Tuple2(output, (Object)outputEdge));
        }
        List selectors = operatorConfig.getOutputSelectors(userCodeClassloader);
        if (selectors == null || selectors.isEmpty()) {
            if (allOutputs.size() == 1) {
                return (Output)((Tuple2)allOutputs.get((int)0)).f0;
            }
            Output[] asArray = new Output[allOutputs.size()];
            for (int i = 0; i < allOutputs.size(); ++i) {
                asArray[i] = (Output)((Tuple2)allOutputs.get((int)i)).f0;
            }
            if (containingTask.getExecutionConfig().isObjectReuseEnabled()) {
                return new CopyingBroadcastingOutputCollector(asArray);
            }
            return new BroadcastingOutputCollector(asArray);
        }
        if (containingTask.getExecutionConfig().isObjectReuseEnabled()) {
            return new CopyingDirectedOutput(selectors, allOutputs);
        }
        return new DirectedOutput(selectors, allOutputs);
    }

    private static <IN, OUT> Output<StreamRecord<IN>> createChainedOperator(StreamTask<?, ?> containingTask, StreamConfig operatorConfig, Map<Integer, StreamConfig> chainedConfigs, ClassLoader userCodeClassloader, Map<StreamEdge, RecordWriterOutput<?>> streamOutputs, List<StreamOperator<?>> allOperators) {
        Output output = OperatorChain.createOutputCollector(containingTask, operatorConfig, chainedConfigs, userCodeClassloader, streamOutputs, allOperators);
        OneInputStreamOperator chainedOperator = (OneInputStreamOperator)operatorConfig.getStreamOperator(userCodeClassloader);
        chainedOperator.setup(containingTask, operatorConfig, output);
        allOperators.add(chainedOperator);
        if (containingTask.getExecutionConfig().isObjectReuseEnabled()) {
            return new ChainingOutput(chainedOperator);
        }
        TypeSerializer inSerializer = operatorConfig.getTypeSerializerIn1(userCodeClassloader);
        return new CopyingChainingOutput(chainedOperator, inSerializer);
    }

    private static <T> RecordWriterOutput<T> createStreamOutput(StreamEdge edge, StreamConfig upStreamConfig, int outputIndex, Environment taskEnvironment, String taskName) {
        int numKeyGroups;
        TypeSerializer outSerializer = upStreamConfig.getTypeSerializerOut(taskEnvironment.getUserClassLoader());
        StreamPartitioner<?> outputPartitioner = edge.getPartitioner();
        LOG.debug("Using partitioner {} for output {} of task ", new Object[]{outputPartitioner, outputIndex, taskName});
        ResultPartitionWriter bufferWriter = taskEnvironment.getWriter(outputIndex);
        if (outputPartitioner instanceof ConfigurableStreamPartitioner && 0 < (numKeyGroups = bufferWriter.getNumTargetKeyGroups())) {
            ((ConfigurableStreamPartitioner)((Object)outputPartitioner)).configure(numKeyGroups);
        }
        StreamRecordWriter output = new StreamRecordWriter(bufferWriter, outputPartitioner, upStreamConfig.getBufferTimeout());
        output.setMetricGroup(taskEnvironment.getMetricGroup().getIOMetricGroup());
        return new RecordWriterOutput(output, outSerializer);
    }

    private static final class CopyingBroadcastingOutputCollector<T>
    extends BroadcastingOutputCollector<T> {
        public CopyingBroadcastingOutputCollector(Output<StreamRecord<T>>[] outputs) {
            super(outputs);
        }

        @Override
        public void collect(StreamRecord<T> record) {
            for (int i = 0; i < this.outputs.length - 1; ++i) {
                Output output = this.outputs[i];
                StreamRecord<T> shallowCopy = record.copy(record.getValue());
                output.collect(shallowCopy);
            }
            this.outputs[this.outputs.length - 1].collect(record);
        }
    }

    private static class BroadcastingOutputCollector<T>
    implements Output<StreamRecord<T>> {
        protected final Output<StreamRecord<T>>[] outputs;
        private final Random RNG = new XORShiftRandom();

        public BroadcastingOutputCollector(Output<StreamRecord<T>>[] outputs) {
            this.outputs = outputs;
        }

        @Override
        public void emitWatermark(Watermark mark) {
            for (Output<StreamRecord<T>> output : this.outputs) {
                output.emitWatermark(mark);
            }
        }

        @Override
        public void emitLatencyMarker(LatencyMarker latencyMarker) {
            if (this.outputs.length > 0) {
                if (this.outputs.length == 1) {
                    this.outputs[0].emitLatencyMarker(latencyMarker);
                } else {
                    this.outputs[this.RNG.nextInt(this.outputs.length)].emitLatencyMarker(latencyMarker);
                }
            }
        }

        public void collect(StreamRecord<T> record) {
            for (Output<StreamRecord<T>> output : this.outputs) {
                output.collect(record);
            }
        }

        public void close() {
            for (Output<StreamRecord<T>> output : this.outputs) {
                output.close();
            }
        }
    }

    private static final class CopyingChainingOutput<T>
    extends ChainingOutput<T> {
        private final TypeSerializer<T> serializer;

        public CopyingChainingOutput(OneInputStreamOperator<T, ?> operator, TypeSerializer<T> serializer) {
            super(operator);
            this.serializer = serializer;
        }

        @Override
        public void collect(StreamRecord<T> record) {
            try {
                this.numRecordsIn.inc();
                StreamRecord<Object> copy = record.copy(this.serializer.copy(record.getValue()));
                this.operator.setKeyContextElement1(copy);
                this.operator.processElement(copy);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not forward element to next operator", e);
            }
        }
    }

    private static class ChainingOutput<T>
    implements Output<StreamRecord<T>> {
        protected final OneInputStreamOperator<T, ?> operator;
        protected final Counter numRecordsIn;

        public ChainingOutput(OneInputStreamOperator<T, ?> operator) {
            this.operator = operator;
            this.numRecordsIn = ((OperatorMetricGroup)operator.getMetricGroup()).getIOMetricGroup().getNumRecordsInCounter();
        }

        public void collect(StreamRecord<T> record) {
            try {
                this.numRecordsIn.inc();
                this.operator.setKeyContextElement1(record);
                this.operator.processElement(record);
            }
            catch (Exception e) {
                throw new ExceptionInChainedOperatorException(e);
            }
        }

        @Override
        public void emitWatermark(Watermark mark) {
            try {
                this.operator.processWatermark(mark);
            }
            catch (Exception e) {
                throw new ExceptionInChainedOperatorException(e);
            }
        }

        @Override
        public void emitLatencyMarker(LatencyMarker latencyMarker) {
            try {
                this.operator.processLatencyMarker(latencyMarker);
            }
            catch (Exception e) {
                throw new ExceptionInChainedOperatorException(e);
            }
        }

        public void close() {
            try {
                this.operator.close();
            }
            catch (Exception e) {
                throw new ExceptionInChainedOperatorException(e);
            }
        }
    }
}

