/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.io.StreamInputProcessor;
import org.apache.flink.streaming.runtime.tasks.StreamTask;

@Internal
public class OneInputStreamTask<IN, OUT>
extends StreamTask<OUT, OneInputStreamOperator<IN, OUT>> {
    private StreamInputProcessor<IN> inputProcessor;
    private volatile boolean running = true;

    @Override
    public void init() throws Exception {
        StreamConfig configuration = this.getConfiguration();
        TypeSerializer inSerializer = configuration.getTypeSerializerIn1(this.getUserCodeClassLoader());
        int numberOfInputs = configuration.getNumberOfInputs();
        if (numberOfInputs > 0) {
            InputGate[] inputGates = this.getEnvironment().getAllInputGates();
            this.inputProcessor = new StreamInputProcessor(inputGates, inSerializer, this, configuration.getCheckpointMode(), this.getEnvironment().getIOManager(), this.getEnvironment().getTaskManagerInfo().getConfiguration());
            this.inputProcessor.setMetricGroup(this.getEnvironment().getMetricGroup().getIOMetricGroup());
        }
    }

    @Override
    protected void run() throws Exception {
        OneInputStreamOperator operator = (OneInputStreamOperator)this.headOperator;
        StreamInputProcessor<IN> inputProcessor = this.inputProcessor;
        Object lock = this.getCheckpointLock();
        while (this.running && inputProcessor.processInput(operator, lock)) {
        }
    }

    @Override
    protected void cleanup() throws Exception {
        if (this.inputProcessor != null) {
            this.inputProcessor.cleanup();
        }
    }

    @Override
    protected void cancelTask() {
        this.running = false;
    }
}

